<?php
	/*
		Low-level parameters for factory configuration.

		Design and implementation by Logilin (www.logilin.fr)
	*/
	require('hytem-header.php');

	if (! $Factory_mode) {
		header("Location: /index.php");
	}

	if ((isset($_POST['submit-button']))
	 && (isset($_FILES['browse-button']['name']))
	 && (isset($_FILES['browse-button']['tmp_name']))) {
		if (! is_uploaded_file ($_FILES['browse-button']['tmp_name'])) {

			echo '<script type="text/javascript">alert("Unable to upload the file.");</script>';

		} else {

			$source_file = $_FILES['browse-button']['tmp_name'];
			$target_dir  = '/data/custom/';
			$target_file = $target_dir . basename($_FILES['browse-button']['name']);
			$imageFileType = pathinfo($target_file,PATHINFO_EXTENSION);
			if (move_uploaded_file($source_file, $target_file)) {
				exec('sync');
				exec('sync');
				echo '<script type="text/javascript">alert("File uploaded");</script>';
			} else {
				echo '<script type="text/javascript">alert("File '.$source_file.' NOT uploaded");</script>';
			}
		}
		unset($_FILES['browse-button']);
		unset($_POST['submit-button']);
	}

	# These parameters are set by the Makefile.
	$maximal_number_of_groups = 16;
	$maximal_devices_per_group = 16;
	$maximal_devices_no_group = 18;
	$maximal_allowed_number_of_devices = 256;

?>
<!DOCTYPE html>
<html>

	<head>
		<?php  fill_html_head_block(); ?>
	</head>


	<body onselectstart='return false;' oncontextmenu='return false;' style='overflow-y: scroll; overflow-x: auto; width: 99%;' >

		<?php fill_html_header_block("Factory Setup"); ?>

		<?php fill_tabs_block("factory",""); ?>

		<div class="content">

			<table style='margin: auto;'>
				<tr>
					<td>
						<table class="factory-setup-pad">
							<tr>
								<td colspan="2" style="text-align:center;">
									<strong>
										<span id="devices-title-label">Devices</span>
									</strong>
								</td>
							</tr><tr>
								<td colspan="2">
									&nbsp;
								</td>
							</tr><tr>
								<td style="text-align:right;">
									<span id="supported-devices-label">Supported devices:</span>&nbsp;
								</td><td>
									<select id="supported-devices" onchange='field_modified();' >
										<option value="1" id="attenuators-only-label" >
											Attenuators only
										</option>
										<option value="2" id="switches-only-label" >
											Switches only
										</option>
										<option value="3" id="attenuators-switches-label" >
											Attenuators + Switches
										</option>
										<option value="4" id="spst-only-label" >
											SPST only
										</option>
										<option value="5" id="attenuators-spst-label" >
											Attenuators + SPST
										</option>
										<option value="6" id="switches-spst-label" >
											Switches + SPST
										</option>
										<option value="7" id="attenuators-switches-spst-label">
											Attenuators + Switches + SPST
										</option>
									</select>
								</td>
							</tr><tr>
								<td colspan="2">
									&nbsp;
								</td>
							</tr><tr>
								<td style="text-align:right;">
									<span id="number-of-groups-label">Number of groups:</span>&nbsp;
								</td><td>
									<input type="text" id="number-of-groups" class="factory-input" onkeypress='field_modified();' onchange='field_modified();' >
								</td>
							</tr><tr>
								<td style="text-align:right;">
									<span id="devices-per-group-label">Devices per group:</span>&nbsp;
								</td><td>
									<input type="text" id="devices-per-group" class="factory-input" onkeypress='field_modified();' onchange='field_modified();' >
								</td>
							</tr><tr>
								<td colspan="2">
									&nbsp;
								</td>
							</tr><tr>
								<td style="text-align:right;">
									<span id="attenuators-range-label">Attenuators range:</span>&nbsp;
								</td><td>
									<input type="radio" name="attenuators-range" value="1" id="attenuators-6250" onclick='field_modified();'>
									<label for="attenuator-6250">62.5</label>
									<input type="radio" name="attenuators-range" value="2" id="attenuators-9350" onclick='field_modified();'>
									<label for="attenuator-9350">93.5</label>
									<input type="radio" name="attenuators-range" value="3" id="attenuators-11000" onclick='field_modified();'>
									<label for="attenuator-11000">110</label>
								</td>
							</tr><tr>
								<td style="text-align:right;">
									<span id="throws-per-switch-label">Throws per switch:</span>&nbsp;
								</td><td>
									<input type="text" id="throws-per-switch" class="factory-input" onkeypress='field_modified();' onchange='field_modified();' >
								</td>
							</tr>
						</table>

						<table class="factory-setup-pad">
							<tr>
								<td colspan="2" style="text-align:center;">
									<strong>
										<span id="system-identification-label">System identification</span>
									</strong>
								</td>
							</tr><tr>
								<td colspan="2">
									&nbsp;
								</td>
							</tr><tr>
								<td style="text-align:right;">
									<span id="product-number-label">Product number:</span>&nbsp;
								</td><td>
									<input type="text" id="product-number" class="factory-input" onkeypress='field_modified();' onchange='field_modified();' >
								</td>
							</tr><tr>
								<td style="text-align:right;">
									<span id="serial-number-label">Serial number:</span>&nbsp;
								</td><td>
									<input type="text" id="serial-number" class="factory-input" onkeypress='field_modified();' onchange='field_modified();' >
								</td>
							</tr>
						</table>
					</td>
					<td style='vertical-align: top;'>
						<table class='factory-setup-pad'>
							<tr>
								<td colspan="2" style="text-align:center;">
									<strong>
										<span id="synchronous-output-label">Synchronous output</span>
									</strong>
								</td>
							</tr><tr>
								<td colspan="2">
									&nbsp;
								</td>
							</tr><tr>
								<td style="text-align:right;">
									<span id="spi-output-type-label">Output type(*):</span>&nbsp;
								</td><td>
									<select id="spi-output-type" onchange='field_modified();' >
										<option value="0">
											GPIO
										</option>
										<option id="spi-controller-label" value="1">
											SPI Controller
										</option>
									</select>
								</td>
							</tr><tr>
								<td colspan="2">
									&nbsp;
								</td>
							</tr><tr>
								<td style="text-align:right;">
									<span id="spi-output-speed-label">SPI controller speed(*):</span>&nbsp;
								</td><td>
									<input type="text" id="spi-speed" class="factory-input" onkeypress='field_modified();' onchange='field_modified();' >
								</td>
							</tr><tr>
								<td style="text-align:right;">
									<span id="spi-frame-length-label">Device frame length:</span>&nbsp;
								</td><td>
									<select id="spi-width" onchange='field_modified();' >
										<option value="0">
											8 bits
										</option>
										<option value="1">
											16 bits
										</option>
									</select>
								</td>
							</tr><tr>
								<td style="text-align:right;">
									<span id="spi-bytes-order-label">Bytes order for 16-bits frames:</span>&nbsp;
								</td><td>
									<select id="spi-bytes-order" onchange='field_modified();' >
										<option id="spi-lsb-first-label" value="0">
											LSB first
										</option>
										<option id="spi-msb-first-label" value="1">
											MSB first
										</option>
									</select>
								</td>
							</tr><tr>
								<td style="text-align:right;">
									<span id="spi-devices-order-label">Devices order:</span>&nbsp;
								</td><td>
									<select id="spi-order" onchange='field_modified();' >
										<option value="0">
											1 -> N
										</option>
										<option value="1">
											N -> 1
										</option>
									</select>
								</td>
							</tr><tr>
								<td style="text-align:right;">
									<span id="spi-data-polarity-label">Data polarity:</span>&nbsp;
								</td><td>
									<select id="spi-data-polarity" onchange='field_modified();' >
										<option value="0" id='spi-data-polarity-normal'>
											Normal
										</option>
										<option value="1" id='spi-data-polarity-inverted'>
											Inverted
										</option>
									</select>
								</td>
							</tr>
						</table>
						<table class='factory-setup-pad'>
							<tr>
								<td colspan="2" style="text-align:center;">
									<strong>
										<span id="system-options-label">System options</span>
									</strong>
								</td>
							</tr><tr>
								<td colspan="2">
									&nbsp;
								</td>
							</tr><tr>
								<td>
									&nbsp;
								</td><td>
									<input type="checkbox" name="multiusers-system-check" id="multiusers-system-check" onclick='field_modified();'>
									<label id="multiusers-label" for="multiusers-system-check">Multiusers (*)</label>
								</td>
							</tr>
						</table>
						<table class='factory-setup-pad'>
							<tr>
								<td colspan='2' style='text-align:center;'>
									<strong><span id="board-model-label">Board Model</span></strong>
								</td>
							</tr><tr>
								<td colspan='2'>
									&nbsp;
								</td>
							</tr><tr>
								<td>
									&nbsp;
								</td><td>
									<select id='board-model' onchange='field_modified();' >";
									</select> (*)
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td style='text-align: right;' colspan="2">
						<p>
							<small>(*) <span id="system-reboot-needed-label">these parameters require a system reboot to be taken in account.</span></small>
						</p>
					</td>
				</tr>
			</table>
			<br/>

			<table class="factory-ok-cancel-table">
				<tr>
					<td>
						<input type="button" value="Ok" id="ok-button" onclick="ok_button_cb();" disabled="true" >
					</td><td>
						<input type="button" value="Cancel" id="cancel-button" onclick="update_all();" disabled="true" >
					</td>
				</tr>
			</table>
			<br/>

			<form action="factory.php" method="post" enctype="multipart/form-data" id="upload-form">
				<table class="factory-setup-pad">
					<tr>
						<td style="text-align:center;">
							<strong>
								<span id="uploading-files-label">Uploading custom files</span>
							</strong>
						</td>
					</tr><tr>
						<td style="text-align: center;">
							<span id="uploading-content-label">(help text, logo...)</span>
						</td>
					</tr><tr>
						<td>
							&nbsp;
						</td>
					</tr><tr>
						<td style="text-align: center;">
							<input type="file" name="browse-button" id="browse-button" value="Browse..."/>
						</td>
					</tr><tr>
						<td style="text-align: center;">
							<input type="submit" name="submit-button" id="submit-button" value="Upload">
						</td>
					</tr>
				</table>
			</form>

		</div>



		<script type="text/javascript">

			var Nb_devices = 0;
			var Board_model = 0;

			window.onload = function()
			{
				translate_factory_widgets();

				update_header_from_lang();

				update_all();
			}



			function translate_factory_widgets()
			{
				if (localStorage.getItem("HytemLang") == "fr") {
					document.getElementById('devices-title-label').innerHTML = "Équipements";
					document.getElementById('supported-devices-label').innerHTML = "Équipements supportés&nbsp;:";
					document.getElementById('attenuators-only-label').innerHTML = "Atténuateurs uniquement";
					document.getElementById('switches-only-label').innerHTML = "Switches uniquements";
					document.getElementById('attenuators-switches-label').innerHTML = "Atténuateurs + Switches";
					document.getElementById('spst-only-label').innerHTML = "SPST uniquement";
					document.getElementById('attenuators-spst-label').innerHTML = "Atténuateurs + SPST";
					document.getElementById('switches-spst-label').innerHTML = "Switches + SPST";
					document.getElementById('attenuators-switches-spst-label').innerHTML = "Atténuateurs + Switches + SPST";
					document.getElementById('number-of-groups-label').innerHTML = "Nombre de groupes&nbsp;:";
					document.getElementById('devices-per-group-label').innerHTML = "Équipements par groupe&nbsp;:";
					document.getElementById('attenuators-range-label').innerHTML = "Atténuation max&nbsp;:";
					document.getElementById('throws-per-switch-label').innerHTML = "Sorties par switch&nbsp;:";

					document.getElementById('system-identification-label').innerHTML = "Identification Système";
					document.getElementById('product-number-label').innerHTML = "Numéro produit&nbsp;:";
					document.getElementById('serial-number-label').innerHTML = "Numéro de série&nbsp;:";
					document.getElementById('system-identification-label').innerHTML = "Identification Système";
					document.getElementById('product-number-label').innerHTML = "Numéro produit&nbsp;:";
					document.getElementById('serial-number-label').innerHTML = "Numéro de série&nbsp;:";

					document.getElementById('synchronous-output-label').innerHTML = "Sortie série synchrone";
					document.getElementById('spi-output-type-label').innerHTML = "Type de sortie&nbsp;:";
					document.getElementById('spi-controller-label').innerHTML = "Contrôleur SPI";
					document.getElementById('spi-output-speed-label').innerHTML = "Vitesse SPI(*)&nbsp;:";
					document.getElementById('spi-frame-length-label').innerHTML = "Taille de trame&nbsp;:";
					document.getElementById('spi-bytes-order-label').innerHTML = "Ordre trames 16 bits&nbsp;:";
					document.getElementById('spi-lsb-first-label').innerHTML = "Poids faible d'abord";
					document.getElementById('spi-msb-first-label').innerHTML = "Poids fort d'abord";
					document.getElementById('spi-devices-order-label').innerHTML = "Ordre des équipements&nbsp;:";
					document.getElementById('spi-data-polarity-label').innerHTML = "Polarité du signal&nbsp;:";
					document.getElementById('spi-data-polarity-normal').innerHTML = "Normale";
					document.getElementById('spi-data-polarity-inverted').innerHTML = "Inversée";

					document.getElementById('system-options-label').innerHTML = "Options système";
					document.getElementById('multiusers-label').innerHTML = "Multi-utilisateurs";

					document.getElementById('board-model-label').innerHTML = "Modèle carte";

					document.getElementById('system-reboot-needed-label').innerHTML = "Ces paramètres nécessitent un redémarrage du système";

					document.getElementById('uploading-files-label').innerHTML = "Téléchargement fichiers personnalisés";
					document.getElementById('uploading-content-label').innerHTML = "(texte d'aide, logo...)";
				}
			}



			function update_all()
			{
				var xhr = get_xhr_object();

				if (xhr == null)
					return;

				xhr.onreadystatechange = function()
				{
					if ((xhr.readyState == 4) && (xhr.status == 200)) {

						var response = xhr.responseText;
						var values = response.split("%");
						var i = 0;

						document.getElementById('supported-devices').selectedIndex = values[1] - 1;
						document.getElementById('number-of-groups').value = values[2];
						document.getElementById('devices-per-group').value = values[3];

						if (values[4] == "6250") {
							document.getElementById('attenuators-6250').checked = true;
						} else if (values[4] == "9350") {
							document.getElementById('attenuators-9350').checked = true;
						} else {
							document.getElementById('attenuators-11000').checked = true;
						}

						document.getElementById('throws-per-switch').value = values[5];
						document.getElementById('product-number').value = values[6];
						document.getElementById('serial-number').value = values[7];

						document.getElementById('spi-output-type').selectedIndex = values[8];
						document.getElementById('spi-speed').value = values[9];
						document.getElementById('spi-order').selectedIndex = values[10];
						document.getElementById('spi-width').selectedIndex = values[11];
						document.getElementById('spi-bytes-order').selectedIndex = values[12] & 0x01;
						document.getElementById('spi-data-polarity').selectedIndex = (values[12] & 0x02) >> 1;

						Board_model = parseInt(values[14]);

						var board_model_select = document.getElementById("board-model");

						board_model_select.options.length = 0;
						switch (Board_model) {
							case 1: // Banana Pro
							case 2: // Banana Pi M1
							case 3: // Banana Pi M1+
								board_model_select.options[board_model_select.options.length] = new Option('Banana Pro', '1', false, false);
								board_model_select.options[board_model_select.options.length] = new Option('Banana Pi M1', '2', false, false);
								board_model_select.options[board_model_select.options.length] = new Option('Banana Pi M1+', '3', false, false);
								break;
							case 4: // Phyboard
								board_model_select.options[board_model_select.options.length] = new Option('Phyboard Mira', '4', false, false);
								break;
							case 5: // Raspberry Pi
								board_model_select.options[board_model_select.options.length] = new Option('Raspberry Pi 3', '5', false, false);
								break;
						}
						board_model_select.value = Board_model;

						document.getElementById('multiusers-system-check').checked =
							<?php
								if ($Multiusers)
									echo 'true';
								else
									echo 'false';
							?>;
						window.onbeforeunload=function(e){};
						document.getElementById('ok-button').disabled = true;
						document.getElementById('cancel-button').disabled = true;
					}
				};
				xhr.open("GET", "cgi-bin/get-shm-data", true);
				xhr.send();
			}



			function ok_button_cb()
			{
				if (fields_ok())
					save_all_parameters();
			}



			function fields_ok()
			{
				var nb_groups = parseInt(document.getElementById('number-of-groups').value);
				var dev_per_group = parseInt(document.getElementById('devices-per-group').value);


				if ((nb_groups < 1) || (nb_groups > <?php echo $maximal_number_of_groups; ?>)) {
					if (localStorage.getItem("HytemLang") == "fr") {
						alert("Nombre de groupes invalide ([1-<?php echo $maximal_number_of_groups; ?>])");
					} else {
						alert("Wrong number of groups ([1-<?php echo $maximal_number_of_groups; ?>])");
					}
					return false;
				}

				if (nb_groups == 1) {
					if ((dev_per_group < 1) || (dev_per_group > <?php echo $maximal_devices_no_group; ?>)) {
						if (localStorage.getItem("HytemLang") == "fr") {
							alert("Nombre d'équipements par groupe invalide ([1-<?php echo $maximal_devices_no_group; ?>])");
						} else {
							alert("Wrong number of devices per group ([1-<?php echo $maximal_devices_no_group; ?>])");
						}
						return false;
					}
				} else {
					if ((dev_per_group < 1) || (dev_per_group > <?php echo $maximal_devices_per_group; ?>)) {
						if (localStorage.getItem("HytemLang") == "fr") {
							alert("Nombre d'équipements par groupe invalide ([1-<?php echo $maximal_devices_no_group; ?>])");
						} else {
							alert("Wrong number of devices per group ([1-<?php echo $maximal_devices_per_group; ?>])");
						}
						return false;
					}
				}

				if (nb_groups * dev_per_group > <?php echo $maximal_allowed_number_of_devices; ?>) {
					if (localStorage.getItem("HytemLang") == "fr") {
						alert("Nombre d'équipements invalide ([1-<?php echo $maximal_allowed_number_of_devices; ?>])");
					} else {
						alert("Wrong number of devices ([1-<?php echo $maximal_allowed_number_of_devices; ?>])");
					}
					return false;
				}

				var throws_per_switch = parseInt(document.getElementById('throws-per-switch').value);
				var bytes_number = document.getElementById('spi-width').selectedIndex + 1;

				if ((throws_per_switch > 8) && (bytes_number < 2)) {
					if (localStorage.getItem("HytemLang") == "fr") {
						alert("Taille trame SPI trop courte pour " + throws_per_switch + " sorties par switch.");
					} else {
						alert("SPI frame too short for " + throws_per_switch + " throws per switch.");
					}
					return false;
				}

				return true;
			}



			function save_all_parameters()
			{
				save_supported_devices();
			}



			function save_supported_devices()
			{
				var xhr;

				xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							save_number_of_groups();
						}
					};
					xhr.open("GET", "action/set-supported-devices.php?devices="  + (document.getElementById('supported-devices').selectedIndex + 1), true);
					xhr.send();
				}
			}



			function save_number_of_groups()
			{
				var xhr;

				xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							save_devices_per_group();
						}
					};
					xhr.open("GET", "action/set-number-of-groups.php?number="  + document.getElementById('number-of-groups').value, true);
					xhr.send();
				}
			}



			function save_devices_per_group()
			{
				var xhr;

				xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							save_attenuators_range();
						}
					};
					xhr.open("GET", "action/set-devices-per-group.php?number="  + document.getElementById('devices-per-group').value, true);
					xhr.send();
				}
			}



			function save_attenuators_range()
			{
				var xhr;
				var line;

				xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							save_throws_per_switch();
						}
					};
					if (document.getElementById('attenuators-6250').checked) {
						line='action/set-attenuators-range.php?range=6250';
					} else if (document.getElementById('attenuators-9350').checked) {
						line='action/set-attenuators-range.php?range=9350';
					} else {
						line='action/set-attenuators-range.php?range=11000';
					}
					xhr.open("GET", line, true);
					xhr.send();
				}
			}



			function save_throws_per_switch()
			{
				var xhr;

				xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							save_serial_number();
						}
					};
					xhr.open("GET", "action/set-throws-per-switch.php?throws="  + document.getElementById('throws-per-switch').value, true);
					xhr.send();
				}
			}



			function save_serial_number()
			{
				var xhr;

				xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							save_product_number();
						}
					};
					xhr.open("GET", "action/set-serial-number.php?number="  + document.getElementById('serial-number').value.slice(0, 12), true);
					xhr.send();
				}
			}



			function save_product_number()
			{
				var xhr;

				xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							save_multiusers();
						}
					};
					xhr.open("GET", "action/set-product-number.php?number=" + document.getElementById('product-number').value.slice(0, 12), true);
					xhr.send();
				}
			}



			function save_multiusers()
			{
				var xhr;
				var line;

				xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							save_sync_output_type();
						}
					};

					if (document.getElementById('multiusers-system-check').checked) {
						line='action/set-option.php?multiusers=1';
					} else {
						line='action/set-option.php?multiusers=0';
					}
					xhr.open("GET", line, true);
					xhr.send();
				}
			}



			function save_sync_output_type()
			{
				var xhr;

				xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							save_sync_output_speed();
						}
					};
					xhr.open("GET", "action/set-synchronous-output-type.php?type="  + (document.getElementById('spi-output-type').selectedIndex), true);
					xhr.send();
				}
			}



			function save_sync_output_speed()
			{
				var xhr;

				xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							save_sync_output_order();
						}
					};
					xhr.open("GET", "action/set-spi-output-speed.php?speed="  + (document.getElementById('spi-speed').value), true);
					xhr.send();
				}
			}



			function save_sync_output_order()
			{
				var xhr;

				xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							save_sync_output_width();
						}
					};
					xhr.open("GET", "action/set-synchronous-output-order.php?order="  + (document.getElementById('spi-order').selectedIndex), true);
					xhr.send();
				}
			}



			function save_sync_output_width()
			{
				var xhr;

				xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							save_sync_output_bytes_order();
						}
					};
					xhr.open("GET", "action/set-synchronous-output-width.php?width="  + (document.getElementById('spi-width').selectedIndex), true);
					xhr.send();
				}
			}



			function save_sync_output_bytes_order()
			{
				var xhr;

				xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							save_sync_output_data_polarity();
						}
					};
					xhr.open("GET", "action/set-synchronous-output-bytes-order.php?order="  + document.getElementById('spi-bytes-order').selectedIndex, true);
					xhr.send();
				}
			}



			function save_sync_output_data_polarity()
			{
				var xhr;

				xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							save_board_model();
						}
					};
					;
					xhr.open("GET", "action/set-synchronous-data-polarity.php?polarity="  + document.getElementById('spi-data-polarity').selectedIndex, true);
					xhr.send();
				}
			}



			function save_board_model()
			{
				if ((Board_model < 1) || (Board_model > 3)) {
					update_all();
					return;
				}

				var xhr;

				xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							update_all();
						}
					};
					xhr.open("GET", "action/set-board-model.php?model="  + document.getElementById("board-model").value, true);
					xhr.send();
				}
			}


			function field_modified ()
			{
				document.getElementById('ok-button').disabled = false;
				document.getElementById('cancel-button').disabled = false;
				window.onbeforeunload = function (e) {
					return "Your modifications will be lost";
				};
			}

		</script>
	</body>
</html>
