<?php
	/*
		Sequences editor.

		Design and implementation by Logilin (www.logilin.fr) for Hytem (www.hytem.net)
	*/
	require('hytem-header.php');
	if (! $Logged_in) {
		header("Location: /index.php");
	}
?>
<!DOCTYPE html>
<html>
	<head>
		<?php  fill_html_head_block(); ?>
		<script type="text/javascript" src="js/jquery-mousewheel-min.js"></script>
		<script type="text/javascript" src="js/vertical-slider.js"></script>
		<script type="text/javascript" src="js/vertical-slider-image.js"></script>
		<style>
			.ui-dialog .ui-state-error { padding: .3em; }

			.scroll-content {position:absolute;top:0;left:0;padding-right:20px}
			.scroll-pane{position:relative;}
			.slider-wrap{position:absolute;right:0.5em;top:0;width:0.8em;background: #eeeeee;border-radius:4px}
			.slider-vertical{position:relative;height:100%;background:none !important;border:none !important}
			.ui-slider-handle{background-color:darkgray;height:10px;margin:0 auto;display:block;position:absolute;background-position:left top !important;}
			.ui-slider-handle img{border:none}
			.scrollbar-top{position:absolute;top:0;}
			.scrollbar-bottom{position:absolute;bottom:0;}
			.scrollbar-grip{position:absolute;top:50%;}
			.slider-wrap{background-color:#bcbcbc;}
		</style>

	</head>
	<body onselectstart="return false;" oncontextmenu="return false;" style='overflow-y: scroll; overflow-x: auto; width: 99%;' >

		<?php fill_html_header_block("Sequence Editor"); ?>

		<?php fill_tabs_block("editor", ""); ?>

		<div id="edit-filename">
		</div>

		<div class="edit-scroll-pane" id="edit-scroll-pane">
			<table class='edit-sequence-table' id='edit-sequence-table'>
				<tr><td class="edit-empty-sequence-table" id="no-sequence-label">No sequence loaded....</td></tr>
				<tr><td class="edit-empty-sequence-table" id="use-new-or-load-label">Please use 'new' or 'load' buttons below.</td></tr>
			</table>
		</div>

		<div class="editor-help-line" id="values-duration-granularity">
			Values in 1/100 dB. Durations in 1/100 seconds.
		</div>

		<div class="editor-graph-div">
			<canvas class="editor-graph-cnv" id="editor-graph-cnv"></canvas>
		</div>

		<div class="editor-buttons-div">
			<div class="editor-buttons-childdiv">
				<input type='button' class='editor-buttons-bt' onclick='new_button_cb();' id='new-button' value='New'        />
				<input type='button' class='editor-buttons-bt' onclick='load_button_cb();' id='load-button'    value='Load...'    />
				<input type='button' class='editor-buttons-bt' onclick='save_button_cb();' id='save-button'   value='Save'       />
				<input type='button' class='editor-buttons-bt' onclick='save_as_button_cb();' id='save-as-button' value='Save as...' />
			</div>
		</div>

		<div id="sequence-load-dialog" class="sequence-load-dialog" title="Load a sequence" hidden style='display: flex; align-items: center;' >
			<select size=10 id="sequence-filename-select">
			</select>
		</div>

		<div id="sequence-save-as-dialog" class="sequence-save-as-dialog" title="Save a sequence as..." hidden >
			<select size=10 id="sequence-save-as-select" onchange="document.getElementById('sequence-save-as-text').value = document.getElementById('sequence-save-as-select').value;" >
			</select>
			<br/><br/>
			<input type='text' class='sequence-save-as-text' id='sequence-save-as-text' value='' />
		</div>

		<div id="sequence-not-saved-confirm-dialog" class="sequence-not-saved-confirm-dialog" title="Sequence not saved" hidden >
			<p><span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 20px 0;"></span><span id="current-sequence-not-saved-label">The current sequence is not saved. Are you sure?</span></p>
		</div>

		<div id="device-type-selection-dialog" class="device-type-selection-dialog" title="Device Type" >
			<p id='select-device-type-label'>Please select the type of the device:</p>
			<select id="device-type-selection-select">
				<option id='attenuator-option'>Attenuator</option>
				<option id ='switch-option'>Switch</option>
				<option id ='spst-option'>SPST</option>
			</select>
		</div>


		<script type="text/javascript" src="js/sequence.js"></script>

		<script type="text/javascript">

			const DEVICE_TYPE_ATTENUATOR = 1;
			const DEVICE_TYPE_SWITCH     = 2;
			const DEVICE_TYPE_SPST       = 4;
			const DEVICE_TYPE_UNKNOWN    = -1;

			var Supported_devices;

			var Attenuators_range;
			var Throws_per_switch;
			var Ask_confirmation_for = "";

			var Current_sequence = null;

			window.onload = function()
			{
				update_header_from_lang();

				jQuery.ajax({
					type: "GET",
					url:"cgi-bin/get-shm-data",
					dataType: 'text',
					async: true,
					success: function(data, textStatus, jqXHR)
					{
						try {
							var response = data;
							var values = response.split("%");
							Supported_devices = values[1];
							Attenuators_range = values[4];
							Throws_per_switch = values[5];
						} catch(e) {
						}
					},
					error: function(jqXHR, textStatus, errorThrown) { },
					complete: function(jqXHR, textStatus) { }
				});
				translate_editor_widgets();
			}



			function translate_editor_widgets()
			{
				if (localStorage.getItem("HytemLang") == "fr") {

					document.getElementById('no-sequence-label').innerHTML = "Pas de séquence chargée.";
					document.getElementById('use-new-or-load-label').innerHTML = "Utilisez les boutons 'Nouvelle' ou 'Charger' ci-dessous.";
					document.getElementById('values-duration-granularity').innerHTML = "Valeurs en 1/100 dB. Durée en 1/100 sec.";
	
					document.getElementById('new-button').value = "Nouvelle";
					document.getElementById('load-button').value = "Charger";
					document.getElementById('save-button').value = "Sauver";
					document.getElementById('save-as-button').value = "Sauver sous...";
	
					document.getElementById('ui-id-1').innerHTML = "Charger une séquence";
					document.getElementById('ui-id-2').innerHTML = "Sauver sous...";

					document.getElementById('ui-id-3').innerHTML = "Séquence non enregistrée.";
					document.getElementById('current-sequence-not-saved-label').innerHTML = "La séquence n'est pas enregistrée. Êtes-vous sûr ?";
					document.getElementById('ui-id-4').innerHTML = "Type d'équipement";
					document.getElementById('select-device-type-label').innerHTML = "Veuillez sélectionner un type d'équipement";
					document.getElementById('attenuator-option').innerHTML = "Atténuateur";
					document.getElementById('switch-option').innerHTML = "Switch";
					document.getElementById('spst-option').innerHTML = "SPST";

					document.getElementById('load-dialog-load-button').innerHTML = "<span class='ui-button-text'>Charger</span>";
					document.getElementById('load-dialog-cancel-button').innerHTML = "<span class='ui-button-text'>Annuler</span>";

					document.getElementById('save-as-dialog-cancel-button').innerHTML = "<span class='ui-button-text'>Annuler</span>";
					document.getElementById('save-as-dialog-save-button').innerHTML = "<span class='ui-button-text'>Sauver</span>";

					document.getElementById('not-saved-dialog-dont-button').innerHTML = "<span class='ui-button-text'>Ne pas sauver</span>";
					document.getElementById('not-saved-dialog-cancel-button').innerHTML = "<span class='ui-button-text'>Annuler</span>";
				}

			}



			// This function is directly called when we change sequence table content.
			function window_resize_cb()
			{
				setSlider($('#edit-scroll-pane'));
			}
			$(window).resize(window_resize_cb);




			function new_button_cb()
			{
				if (Current_sequence == null) {
					new_sequence();
				} else {
					if (Current_sequence.saved) {
						new_sequence();
					} else {
						Ask_confirmation_for = "new";
						not_saved_confirm.dialog("open");
					}
				}
			}



			function load_button_cb()
			{
				if (Current_sequence == null) {
					do_load_sequence();
				} else {
					if (Current_sequence.saved) {
						do_load_sequence();
					} else {
						Ask_confirmation_for = "load";
						not_saved_confirm.dialog("open");
					}
				}
			}



			function dont_save_confirmation()
			{
				if (Ask_confirmation_for == "new")
					new_sequence();
				else
					do_load_sequence();
			}



			function save_button_cb()
			{
				if (Current_sequence != null) {
					if (Current_sequence.filename == "") {
						save_as_button_cb();
					} else {
						save_sequence(Current_sequence.filename);
					}
				}
			}



			function save_as_button_cb()
			{
				if (Current_sequence != null) {
					var xhr = get_xhr_object();
					if (xhr == null)
						return;
					xhr.onreadystatechange = function() {
						if (xhr.readyState == 4) {
							if (xhr.status == 200) {
								var sequence_list = xhr.responseText.split('%');
								document.getElementById('sequence-save-as-select').options.length=0;
								var i;
								for (i = 0; i < sequence_list.length; i ++) {
									if (sequence_list[i].length > 0)
										document.getElementById('sequence-save-as-select').options[i] = new Option(sequence_list[i], sequence_list[i], false, false);
								}
								save_as_dialog.dialog("open");
							}
						}
					};
					xhr.open("GET", "cgi-bin/list-sequences", true);
					xhr.send();
				}
			}



			var load_dialog = $( "#sequence-load-dialog" ).dialog({
				autoOpen: false,
				height: 420,
				width: 350,
				modal: true,
				buttons: {
					"Load": {
						id: 'load-dialog-load-button',
						text: 'Load',
						click: function()
						{
							if (document.getElementById('sequence-filename-select').selectedIndex >= 0) {
								load_sequence(document.getElementById('sequence-filename-select').value);
							}
							load_dialog.dialog("close");
						}
					},
					"Cancel": {
						id: 'load-dialog-cancel-button',
						text: 'Cancel',
						click: function()
						{
							load_dialog.dialog("close");
						}
					},
				},
				close: function() {
				}
			});



			var save_as_dialog = $( "#sequence-save-as-dialog" ).dialog({
				autoOpen: false,
				height: 380,
				width: 350,
				modal: true,
				buttons: {
					"Save": {
						id: 'save-as-dialog-save-button',
						text: 'Save',
						click: function()
						{
							var str = document.getElementById('sequence-save-as-text').value;
							if (str != "") {
								if (str.substring(str.length-4, str.length) != ".sqc")
									str += ".sqc";
								save_sequence(str);
							}
							save_as_dialog.dialog("close");
						},
					},
					"Cancel": {
						id: 'save-as-dialog-cancel-button',
						text: 'Cancel',
						click: function()
						{
							save_as_dialog.dialog("close");
						}
					},
				},
				close: function() {
				}
			});



			var not_saved_confirm = $("#sequence-not-saved-confirm-dialog").dialog({
				autoOpen:  false,
				resizable: false,
				height:200,
				modal: true,
				buttons:
				{
					"Dont": {
						id: 'not-saved-dialog-dont-button',
						text: "Don't save",
						click: function() {
							$(this).dialog( "close" );
							dont_save_confirmation();
						},
					},
					"Cancel": {
						id: 'not-saved-dialog-cancel-button',
						text: 'Cancel',
						click: function()
						{
							$(this).dialog( "close" );
						},
					}
				}
			});


			var device_type_selection_dialog = $( "#device-type-selection-dialog" ).dialog({
				autoOpen: false,
				height: 280,
				width: 350,
				modal: true,
				buttons: {
					"Ok": function()
					{
						var device_type = document.getElementById('device-type-selection-select').selectedIndex;
						device_type_selection_dialog.dialog( "close" );
						if (device_type == 1)
							new_switch_sequence()
						else if (device_type == 2)
							new_spst_sequence()
						else
							new_attenuator_sequence();
					},
					"Cancel": function()
					{
						device_type_selection_dialog.dialog( "close" );
					}
				},
				close: function() {
				}
			});


			function do_load_sequence()
			{
				var xhr = get_xhr_object();
				if (xhr == null)
					return;
				xhr.onreadystatechange = function() {
					if (xhr.readyState == 4) {
						if (xhr.status == 200) {
							var sequence_list = xhr.responseText.split('%');
							document.getElementById('sequence-filename-select').options.length=0;
							var i;
							for (i = 0; i < sequence_list.length; i ++) {
								if (sequence_list[i].length > 0)
									document.getElementById('sequence-filename-select').options[i] = new Option(sequence_list[i], sequence_list[i], false, false);
							}
							load_dialog.dialog("open");
						}
					}
				};
				xhr.open("GET", "cgi-bin/list-sequences", true);
				xhr.send();
			}
		</script>
	</body>
</html>
