<?php
	/*
		"Reboot in progress" page.

		Design and implementation by Logilin (www.logilin.fr).
	*/

	require('hytem-header.php');

	if ((! $Factory_mode) && (! $Admin_logged)) {
		header("Location: /index.php");
	}

?>
<!DOCTYPE html>
<html>
	<head>
		<?php  fill_html_head_block(); ?>
	</head>

	<body onselectstart="return false;" oncontextmenu="return false;" >

		<?php fill_html_header_block(""); ?>

		<div class="content">
			<table id="global-table">
				<tr style="vertical-align: top">
					<td style="vertical-align: top; text-align: center" id='reboot-text'>
						<br/>
						<strong>Reboot.</strong>
						<br/>
						<br/>
						Hytem system is restarting... please wait a few seconds.
					</td>
				</tr>
			</table>
		</div>

		<script type="text/javascript">
			window.onload = function()
			{
				if (localStorage.getItem("HytemLang") == "fr") {
					document.getElementById('reboot-text').innerHTML = "<br/><strong>Redémarrage.</strong><br/><br/>Le système est en cours de redémarrage... Merci de patienter quelques secondes.";
				}

				var xhr = get_xhr_object();
				if (xhr != null) {
					xhr.open("GET", "cgi-bin/fast-reboot", true);
					xhr.send();
					setTimeout(try_to_contact_server, 1000);
				}
			}


			function try_to_contact_server()
			{
				var xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function()
					{
						if (xhr.readyState == 4) {
							if (xhr.status != 200) {
								setTimeout(try_to_contact_server, 1000);
							} else {
								setTimeout(try_again_to_contact_server, 5000);
							}
						}
					};
					xhr.open("GET", "cgi-bin/get-shm-data", true);
					xhr.send();
				}
			}


			function try_again_to_contact_server()
			{
				var xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function()
					{
						if (xhr.readyState == 4) {
							if (xhr.status != 200) {
								setTimeout(try_again_to_contact_server, 1000);
							} else {
								// Ensure reloading by passing a random (unused) parameter.
								window.location.href = "index.php?v=" + Math.floor(Math.random() * 1000);
							}
						}
					};
					xhr.open("GET", "cgi-bin/get-shm-data", true);
					xhr.send();
				}
			}
		</script>
	</body>
</html>
