#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>

#define SHADOW_FILE  "/etc/shadow"
#define LINE_LENGTH  512

int main(int argc, char *argv[])
{
	FILE *fp_shadow;

	char *tmp_name;
	FILE *fp_tmp;

	char line[LINE_LENGTH];
	int found = 0;

	int exit_status = EXIT_FAILURE;

	if ((argc < 3)
	 || ((strcmp(argv[1], "control") != 0)
	  && (strcmp(argv[1], "players") != 0)
	  && (strcmp(argv[1], "reboot") != 0))) {
		printf("Invalid password (or user name).");
		exit(EXIT_FAILURE);
	}

	tmp_name = tempnam("/tmp", "shadow");

	fp_shadow = fopen(SHADOW_FILE, "r");
	if (fp_shadow == NULL) {
		printf("Internal error #1001.");
		exit(EXIT_FAILURE);
	}

	fp_tmp = fopen(tmp_name, "w");
	if (fp_tmp == NULL) {
		printf("Internal error #1002.");
		exit(EXIT_FAILURE);
	}

	while (fgets(line, LINE_LENGTH, fp_shadow) != NULL) {

		if ((strncmp(line, argv[1], strlen(argv[1])) == 0)
		 && (line[strlen(argv[1])] == ':')) {
			fprintf(fp_tmp, "%s:%s:::::::\n", argv[1], argv[2]);
			found = 1;
		} else {
			fputs(line, fp_tmp);
		}
	}
	fclose(fp_tmp);
	fclose(fp_shadow);

	if (! found) {
		printf("User '%s' not found.", argv[1]);
		exit(EXIT_FAILURE);
	}

	fp_tmp = fopen(tmp_name, "r");
	if (fp_tmp == NULL) {
		printf("Internal error #1003.");
		exit(EXIT_FAILURE);
	}

	unlink(tmp_name);

	if (setreuid(0, 0) != 0) {
		printf("Internal error #1004.");
		exit(EXIT_FAILURE);
	}
	if (setregid(0, 0) != 0) {
		printf("Internal error #1005.");
		exit(EXIT_FAILURE);
	}

	if (system("/usr/sbin/rw") != 0) {
		printf("Internal error #1006.");
		exit(EXIT_FAILURE);
	}

	fp_shadow = fopen(SHADOW_FILE, "w");
	if (fp_shadow != NULL) {
		while (fgets(line, LINE_LENGTH, fp_tmp) != NULL) {
			fputs(line, fp_shadow);
		}
		fclose(fp_shadow);
		exit_status = EXIT_SUCCESS;
	} else {
		printf("Internal error #1007.");
	}

	system("/usr/sbin/ro");
	fclose(fp_tmp);

	system("sed -ne '/^control:/p; /^players:/p; /^reboot:/p' /etc/shadow > /data/config/shadow");

	return exit_status;
}
