
#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>

#define LINE_LENGTH  512

int main(int argc, char *argv[])
{
	char line[LINE_LENGTH + 1];
	FILE *fp;
	struct stat status;
	struct passwd *pwd;
	int avoid_gcc_warning;
	(void) avoid_gcc_warning;

	if (argc != 2) {
		printf("Internal error #3000.");
		exit(EXIT_FAILURE);
	}

	if ((strcmp(argv[1], "control") != 0)
	 && (strcmp(argv[1], "players") != 0)
	 && (strcmp(argv[1], "reboot") != 0)) {
		printf("Wrong user name");
		exit(EXIT_FAILURE);
	}

	pwd = getpwnam(argv[1]);
	if (pwd == NULL) {
		printf("Wrong user name.");
		exit(EXIT_FAILURE);
	}

	if (setreuid(0, 0) != 0) {
		printf("Internal error #3001.");
		exit(EXIT_FAILURE);
	}
	if (setregid(0, 0) != 0) {
		printf("Internal error #3002.");
		exit(EXIT_FAILURE);
	}

	snprintf(line, LINE_LENGTH, "/home/%s/.ssh", argv[1]);

	if (stat(line, &status) != 0) {
		exit(EXIT_SUCCESS);
	}

	if ((status.st_mode & S_IFDIR) == 0) {
		printf("Internal error #3003.");
		exit(EXIT_FAILURE);
	}

	snprintf(line, LINE_LENGTH, "/home/%s/.ssh/authorized_keys", argv[1]);

	if (system("/usr/sbin/rw") != 0) {
		printf("Internal error #3004.");
		exit(EXIT_FAILURE);
	}

	fp = fopen(line, "w");
	if (fp == NULL) {
		printf("Internal error #3005.");
		exit(EXIT_FAILURE);
	}
	fclose(fp);
	avoid_gcc_warning = chown(line, pwd->pw_uid, pwd->pw_gid);
	avoid_gcc_warning = chmod(line, 0600);
	avoid_gcc_warning = system("/usr/sbin/ro");
	snprintf(line, LINE_LENGTH, "/bin/cp  /home/%s/.ssh/authorized_keys  /data/config/%s_authorized_keys", argv[1], argv[1]);
	avoid_gcc_warning = system(line);

	return EXIT_SUCCESS;
}
