	#include <fcntl.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <stdint.h>
	#include <string.h>
	#include <unistd.h>
	#include <sys/stat.h>
	#include <sys/mman.h>

	#include "config.h"

int main(void)
{
	int         fd;
	struct stat status;
	char        *shm;
	config_global_parameters_t *params = NULL;
	config_device_t   *devices = NULL;
	config_group_t    *groups = NULL;

	int                i;

	fprintf(stdout, "Content-Type: text/plain\r\n\r\n");

	fd = shm_open(DEVICES_SHM_FILE, O_RDONLY, 0644);
	if (fd < 0) {
		// For debug purposes: 0.0.0.0 means "no device file".
		fprintf(stdout, "0%%0%%0%%0");
		return 0;
	}
	if (fstat(fd, & status) != 0) {
		// For debug purposes: 0.0.0.1 means "unable to get file status"
		fprintf(stdout, "0%%0%%0%%1");
		return 0;
	}
	shm = mmap(NULL, status.st_size, PROT_READ, MAP_SHARED, fd, 0);
	if (shm == MAP_FAILED) {
		// For debug purposes: 0.0.0.2 means "unable to mmap file".
		fprintf(stdout, "0%%0%%0%%2");
		return 0;
	}
	close (fd);

	params  = (config_global_parameters_t *) shm;
	devices = (config_device_t *) (& shm[CONFIG_GLOBAL_PARAMETERS_SIZE]);
	groups  = (config_group_t *)  (& shm[CONFIG_GLOBAL_PARAMETERS_SIZE + CONFIG_DEVICE_TABLE_SIZE]);

	// 0 -> system version (string)

	if (params->version[3] == 0)
		fprintf(stdout, "%d.%d.%d%%", params->version[0], params->version[1], params->version[2]);
	else if (params->version[3] == 1)
		fprintf(stdout, "%d.%d-pre-%d%%", params->version[0], params->version[1], params->version[2]);
	else 
		fprintf(stdout, "%d.%d-dev-%d%%", params->version[0], params->version[1], params->version[2]);

	// 1
	fprintf(stdout, "%d%%", params->supported_devices);
	// 2
	fprintf(stdout, "%d%%%d%%", params->number_of_groups, params->devices_per_group);
	// 4
	fprintf(stdout, "%d%%%d%%", params->attenuators_range, params->throws_per_switch);
	// 6
	fprintf(stdout, "%s%%%s%%", params->product_number, params->serial_number);
	// 8
	fprintf(stdout, "%d%%%d%%", params->sync_output_type, params->sync_output_speed);
	// 10
	fprintf(stdout, "%d%%%d%%", params->sync_output_devices_order, params->sync_output_width);
	// 12
	fprintf(stdout, "%d%%", params->sync_output_data_params);
	// 13
	fprintf(stdout, "%d%%%d%%", params->use_https, params->board_model);
	// 15
	fprintf(stdout, "%s%%", params->system_name);
	// 16
	fprintf(stdout, "0%%0%%0%%0%%0%%0%%0%%0%%"); // filler
	// 24
	for (i = 0; i < 8; i ++)
		fprintf(stdout, "%d%%", params->gpio_status[i]);

	//
	for (i = 0; i < params->number_of_devices; i ++) {
		fprintf(stdout, "%s%%%d%%%d%%%d%%", devices[i].name, devices[i].type, devices[i].current_value, devices[i].lock_id);
		fprintf(stdout, "%d%%%d%%%d%%%f%%", devices[i].min_value, devices[i].max_value, devices[i].granularity, devices[i].display_factor);
		fprintf(stdout, "%d%%%d%%%d%%%d%%", devices[i].lock_ip[0], devices[i].lock_ip[1], devices[i].lock_ip[2], devices[i].lock_ip[3]);
	}


	for (i = 0; i < params->number_of_groups; i ++) {
		fprintf(stdout, "%s%%", groups[i].name);
	}

	return 0;
}
