	#include <fcntl.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <stdint.h>
	#include <string.h>
	#include <unistd.h>
	#include <sys/stat.h>
	#include <sys/mman.h>

	#include "config.h"

int main(void)
{
	int fd;
	config_global_parameters_t *params = NULL;
	int devices_per_groups = 0;

	fd = shm_open(DEVICES_SHM_FILE, O_RDONLY, 0644);
	if (fd >= 0) {
		params = (config_global_parameters_t *) mmap(NULL, CONFIG_GLOBAL_PARAMETERS_SIZE, PROT_READ, MAP_SHARED, fd, 0);
		if (params != MAP_FAILED)
			devices_per_groups = params->devices_per_group;
		close(fd);
	}
	fprintf(stdout, "Content-type: text/plain\r\n\r\n");
	fprintf(stdout, "%d\r\n", devices_per_groups);

	return 0;
}
