<?php
	/*
		System update

		Design and implementation by Logilin (www.logilin.fr).
	*/

	require('hytem-header.php');

	if ((! $Factory_mode) && (! $Admin_logged)) {
		header("Location: /index.php");
	}

	unset($output);
	exec("/home/www/cgi-bin/get-version", $output, $retval);
	$System_board_name = $output[3];

	$Update_prefix = "hytem";
?>
<!DOCTYPE html>
<html>
	<head>
		<?php  fill_html_head_block(); ?>
	</head>

<?php
		if ((isset($_POST["submit"]))
		 && (isset($_FILES["update_file"]["name"]))
		 && (isset($_FILES["update_file"]["tmp_name"]))) {
			$target_dir = "/tmp"; // No final slash!
			$Update_basename = basename($_FILES["update_file"]["name"]);
			$Update_file = $target_dir . "/" . $Update_basename;
			$imageFileType = pathinfo($Update_file, PATHINFO_EXTENSION);
			if (! move_uploaded_file($_FILES["update_file"]["tmp_name"], $Update_file)) {
				unset($Update_file);
			}
			unset($_FILES["update_file"]);
			unset($_POST["submit"]);
		} else {
			unset($Update_file);
			unset($Update_basename);
		}
	?>

	<body onselectstart="return false;" oncontextmenu="return false;"  style='overflow-y: scroll; overflow-x: auto; width: 99%;' >

		<?php fill_html_header_block("Update"); ?>

		<?php fill_tabs_block("update", ""); ?>

		<div class="content">
			<table id="global-table">
				<tr>
					<td colspan="2">
						<table>
							<tr>
								<td>
									<img id="status-image" src="png/update-sign.png" syle="float: left;" width="50px"/>
								</td>
								<td style="text-align: center; vertical-align: middle;">
									<span id="title_span"></span>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td colspan="2">
						&nbsp;
					</td>
				</tr>
				<tr>
					<td style="text-align: center;"  colspan="2">
						<span id="comment_span"></span>
						<br/><br/>&nbsp;
					</td>
				</tr>
				<tr>
					<td class="update_action" colspan="2">
						<form action="update.php" method="post" enctype="multipart/form-data" id="update_form">
							<input class="update_form_button" type="file"   name="update_file" id="update_file" accept='.tar.gz'  />
							<input class="update_form_button" type="submit" value="Upload" name="submit" id="submit_button" onclick="upload_in_progress();" />
						</form>
					</td>
				</tr>
				<tr>
					<td style="text-align: center;" colspan="2">
						<table>
							<tr>
								<td>
									<button class="update_button" id="update_button" type="button" onclick="update_button_cb();">Update</button>
								</td>
								<td>
									<button class="cancel_button" id="cancel_button" type="button" onclick="cancel_button_cb();">Cancel</button>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td style="text-align: center;" colspan="2">
						<table>
							<tr>
								<td>
									<button class="update_button" id="reboot_button" type="button" onclick="reboot_button_cb();">Reboot now</button>
								</td>
								<td>
									<button class="cancel_button" id="later_button" type="button" onclick="later_button_cb();">Later</button>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<span id="update_status"></span>
					</td>
				</tr>
			</table>
		</div>

		<script type="text/javascript">

			window.onload = function()
			{
				update_header_from_lang();

				var tsp = document.getElementById('title_span');

				if (localStorage.getItem("HytemLang") == "fr")
					tsp.innerHTML = 'La version actuelle est&nbsp;: <strong><?php echo "$Update_prefix-$System_board_name-$System_version"; ?></strong>';
				else
					tsp.innerHTML = 'The current version is: <strong><?php echo "$Update_prefix-$System_board_name-$System_version"; ?></strong>';


				var csp = document.getElementById('comment_span');
				var ubt = document.getElementById('update_button');
				var cbt = document.getElementById('cancel_button');
				var rbt = document.getElementById('reboot_button');
				var lbt = document.getElementById('later_button');
				var frm = document.getElementById('update_form');

				rbt.style.display = 'none';
				lbt.style.display = 'none';

				<?php
					if (isset($Update_file)) {
						echo "disable_language_buttons();";
						echo "disable_header_tabs();";
						echo "if (localStorage.getItem('HytemLang') == 'fr') {";
						echo "  tsp.innerHTML = 'Prêt à mettre à jour avec <strong>$Update_basename</strong>';";
						echo "  csp.innerHTML = 'Cliquez sur le bouton `mise à jour` ci-dessous pour démarrer le processus...';";
						echo "} else {";
						echo "  tsp.innerHTML = 'Ready to update system with <strong>$Update_basename</strong>';";
						echo "  csp.innerHTML = 'Click on the `update` button below to start the update process...';";
						echo "}";
						echo "ubt.style.display='block';";
						echo "cbt.style.display='block';";
						echo "frm.style.display='none';";
					} else {

						echo "if (localStorage.getItem('HytemLang') == 'fr') {";
						echo "  csp.innerHTML = 'Vous pouvez installer une nouvelle version en chargeant depuis votre PC un fichier de la forme&nbsp;:<br/><br/>${Update_prefix}-<strong>${System_board_name}</strong>-&lt;version.number&gt;.tar.gz<br/><br/>Sélectionnez un fichier ci-dessous, puis cliquez sur le bouton <em>Upload</em>.';";
						echo "} else {";
						echo "  csp.innerHTML = 'You may install a new version by uploading a file of the form:<br/><br/>${Update_prefix}-<strong>${System_board_name}</strong>-&lt;version.number&gt;.tar.gz<br/><br/>First select a file below, then click on <em>Upload</em> button';";
						echo "}";
						echo "ubt.style.display='none';";
						echo "cbt.style.display='none';";
						echo "frm.style.display='block';";
					}
				?>

				if (localStorage.getItem("HytemLang") == "fr") {
					document.getElementById('update_button').innerHTML = "Mise à jour";
					document.getElementById('cancel_button').innerHTML = "Annuler";
					document.getElementById('reboot_button').innerHTML = "Redémarrer maintenant";
					document.getElementById('later_button').innerHTML = "Plus tard...";
				}

			}


			function disable_language_buttons()
			{
				document.getElementById('en-language-button').style="pointer-events: none;";
				document.getElementById('fr-language-button').style="pointer-events: none;";
			}



			function disable_header_tabs()
			{
				try { document.getElementById('devices-tab').style="pointer-events: none;"; } catch { }
				try { document.getElementById('players-tab').style="pointer-events: none;"; } catch { }
				try { document.getElementById('manager-tab').style="pointer-events: none;"; } catch { }
				try { document.getElementById('editor-tab').style="pointer-events: none;"; } catch { }
				try { document.getElementById('users-tab').style="pointer-events: none;"; } catch { }
				try { document.getElementById('ssh-tab').style="pointer-events: none;"; } catch { }
				try { document.getElementById('setup-tab').style="pointer-events: none;"; } catch { }
				try { document.getElementById('factory-tab').style="pointer-events: none;"; } catch { }
				try { document.getElementById('update-tab').style="pointer-events: none;"; } catch { }
				try { document.getElementById('logout-tab').style="pointer-events: none;"; } catch { }
				try { document.getElementById('hytem-link').style="pointer-events: none;"; } catch { }
			}


			function upload_in_progress()
			{
				document.getElementById('update_form').style.display='none';
				if (localStorage.getItem("HytemLang") == "fr") {
					document.getElementById('comment_span').innerHTML = '<br/><br/>Chargement en cours...<br/><br/>Veuillez patienter quelques secondes.';
				} else {
					document.getElementById('comment_span').innerHTML = '<br/><br/>Upload in progress...<br/><br/>Please wait a few seconds.';
				}
				disable_language_buttons();
				disable_header_tabs();
			}



			function update_button_cb()
			{
				var tsp = document.getElementById('title_span');
				var ubt = document.getElementById('update_button');
				var cbt = document.getElementById('cancel_button');
				var rbt = document.getElementById('reboot_button');
				var lbt = document.getElementById('later_button');

				ubt.style.display='none';
				cbt.style.display='none';
				if (localStorage.getItem("HytemLang") == "fr") {
					tsp.innerHTML = 'Mise à jour en cours...';
				} else {
					tsp.innerHTML = 'Update in progress...';
				}
				rbt.style.display = 'none';
				lbt.style.display = 'none';

				update_step(1);
			}



			function update_step(step)
			{
				var tsp = document.getElementById('title_span');
				var csp = document.getElementById('comment_span');
				var img = document.getElementById('status-image');
				var rbt = document.getElementById('reboot_button');
				var lbt = document.getElementById('later_button');

				if (step == 5) {
					if (localStorage.getItem("HytemLang") == "fr")
						csp.innerHTML = "Étape&nbsp;: " + step + "/7&nbsp;&nbsp;(l'étape 5 prend 2-3 minutes)";
					else
						csp.innerHTML = "Update step: " + step + "/7&nbsp;&nbsp;(step 5 takes about 2-3 minutes)";
				} else if (step == 6) {
					if (localStorage.getItem("HytemLang") == "fr")
						csp.innerHTML = "Étape&nbsp;: " + step + "/7&nbsp;&nbsp;(l'étape 6 prend 1-2 minutes)";
					else
						csp.innerHTML = "Update step: " + step + "/7&nbsp;&nbsp;(step 6 takes about 1-2 minutes)";
				} else {
					if (localStorage.getItem("HytemLang") == "fr")
						csp.innerHTML = "Étape&nbsp;: " + step + "/7&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
					else
						csp.innerHTML = "Update step: " + step + "/7&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				}

				var xhr = get_xhr_object();
				if (xhr == null)
					return;
				xhr.onreadystatechange = function() {
					if (xhr.readyState == 4) {
						if (xhr.status == 200) {

							if (xhr.responseText.substring(0,2) == 'Ok') {
								if (step < 7) {
									update_step(step + 1);
								} else {
									img.src="png/update-ok.png";
									if (localStorage.getItem("HytemLang") == "fr") {
										tsp.innerHTML = "<strong>Mise à jour réussie.</strong>";
										csp.innerHTML = "La nouvelle version sera active après un redémarrage.";
									} else {
										tsp.innerHTML = "<strong>Update sucessful.</strong>";
										csp.innerHTML = "The new version will be effective after reboot.";
									}
									rbt.style.display = 'block';
									lbt.style.display = 'block';
								}
							} else {
								img.src="png/update-fail.png";
								if (localStorage.getItem("HytemLang") == "fr") {
									tsp.innerHTML = "<strong>Échec de mise à jour.</strong>";
									csp.innerHTML = "Vérifiez le fichier de mise à jour et recommencez.";
								} else {
									tsp.innerHTML = "<strong>Update failure.</strong>";
									csp.innerHTML = "Please check the image archive provided and try again.";
								}
							}
						}
					}
				};
				var filename = '';
				<?php
					if (isset($Update_file))
						echo "filename = '$Update_file';";
				?>
				xhr.open("GET", "cgi-bin/system-update?step=" + step + "&filename=" + filename, true);
				xhr.send();
			}



			function cancel_button_cb()
			{
				window.location.href = "index.php";
			}



			function reboot_button_cb()
			{
				if (localStorage.getItem("HytemLang") == "fr") {
					if (confirm("Êtes-vous sûr de vouloir redémarrer maintenant ?")) {
						window.location.href = "reboot.php";
					}
				} else {
					if (confirm("Are you sure you want to reboot the system now?")) {
						window.location.href = "reboot.php";
					}
				}
			}



			function later_button_cb()
			{
				window.location.href = "index.php";
			}

		</script>
	</body>
</html>
