<?php
	/*
		SSH account management for the Hytem device control system.

		Design and implementation by Logilin (www.logilin.fr) for Hytem (www.hytem.net)
	*/

	require('hytem-header.php');

	if (! (($Admin_logged) || ($Factory_mode)))
		header("Location: http:/index.php");

?>
<!DOCTYPE html>
<html>
	<head>
		<?php  fill_html_head_block(); ?>

		<style>
			label, input { display:block; }
			input.text { margin-bottom:12px; width:95%; padding: .4em; }
			fieldset { padding:0; border:0; margin-top:25px; }
			h1 { font-size: 1.2em; margin: .6em 0; }
			.ui-dialog .ui-state-error { padding: .3em; }
			.validateTips { border: 1px solid transparent; padding: 0.3em; }
		</style>
	</head>

	<body oncontextmenu="return false;"  style='overflow-y: scroll; overflow-x: auto; width: 99%;' >

		<?php fill_html_header_block("SSH key management"); ?>

		<?php fill_tabs_block("ssh", ""); ?>

		<div class="content">

			<table style='margin: auto; background: white; padding: 10px; border: 1px solid #bdbfbc;'>
				<tr>
					<td>
						<table>
							<tr>
								<td>
									<h3 id='ssh-special-accounts-title'>SSH Special Accounts</h3>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table class="factory-setup-pad">
							<tr>
								<td colspan="3" style='text-align: center;' id='control-account-title'>
									<strong>The "control" account </strong>
								</td>
							</tr>
							<tr><td>&nbsp;</td></tr>
							<tr>
								<td colspan="3" id='control-account-description'>
									The "control" special user can act on any
									devices by connecting with SSH and entering
									the device index, then using the external
									legacy API.
								</td>
							</tr>
							<tr><td>&nbsp;</td></tr>
								<td style='text-align: center;'>
									<button type="button" class="ssh_tab_button" id="change_control_password" onclick="change_control_password_cb();">Change<br/>password</button>
								</td>
								<td style='text-align: center;'>
									<button type="button" class="ssh_tab_button" id="add_control_key" onclick="add_control_key_cb();">Add<br/>SSH key</button>
								</td>
								<td style='text-align: center;'>
									<button type="button" class="ssh_tab_button" id="revoke_control_keys" onclick="revoke_control_keys_cb();">Revoke<br/>SSH keys</button>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td>&nbsp;</td></tr>
				<tr>
					<td>
						<table class="factory-setup-pad">
							<tr>
								<td colspan="3" style='text-align: center;' id='players-account-title'>
									<strong>The "players" account </strong>
								</td>
							</tr>
							<tr><td>&nbsp;</td></tr>
							<tr>
								<td colspan="3" id='players-account-description'>
									The "players" special user can start or stop
									playing sequences on any device using the
									player API.
								</td>
							</tr>
							<tr><td>&nbsp;</td></tr>
								<td style='text-align: center;'>
									<button type="button" class="ssh_tab_button" id="change_players_password" onclick="change_players_password_cb();">Change<br/>password</button>
								</td>
								<td style='text-align: center;'>
									<button type="button" class="ssh_tab_button" id="add_players_key" onclick="add_players_key_cb();">Add<br/>SSH key</button>
								</td>
								<td style='text-align: center;'>
									<button type="button" class="ssh_tab_button" id="revoke_players_keys" onclick="revoke_players_keys_cb();">Revoke<br/>SSH keys</button>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td>&nbsp;</td></tr>
				<tr>
					<td>
						<table class="factory-setup-pad">
							<tr>
								<td colspan="3" style='text-align: center;' id='reboot-account-title'>
									<strong>The "reboot" account </strong>
								</td>
							</tr>
							<tr><td>&nbsp;</td></tr>
							<tr>
								<td colspan="3" id='reboot-account-description'>
									The "reboot" special user can remotely restart the sytem.
								</td>
							</tr>
							<tr><td>&nbsp;</td></tr>
								<td style='text-align: center;'>
									<button type="button" class="ssh_tab_button" id="change_reboot_password" onclick="change_reboot_password_cb();">Change<br/>password</button>
								</td>
								<td style='text-align: center;'>
									<button type="button" class="ssh_tab_button" id="add_reboot_key" onclick="add_reboot_key_cb();">Add<br/>SSH key</button>
								</td>
								<td style='text-align: center;'>
									<button type="button" class="ssh_tab_button" id="revoke_reboot_keys" onclick="revoke_reboot_keys_cb();">Revoke<br/>SSH keys</button>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td>&nbsp;</td></tr>
				<tr>
					<td>
						<table class="factory-setup-pad">
							<tr>
								<td>
									<input type="checkbox" name="keep-tcp-port-check" id="keep-tcp-port-check" onclick='keep_tcp_port_check_changed();'>
								</td><td id='keep-tcp-port-label'>
                                                                        Keep device TCP ports accessible with Telnet
								</td>
							</tr><tr>
								<td colspan="2" id='option-needs-system-reboot'>
									<small>(This option requires a system reboot to be taken in account).</small>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</div>

		<div id="change_control_password_dialog" title="Change 'control' password" hidden >
			<p class="change_control_password_dialog_tip"></p>
			<form action="" method="post">
				<fieldset>
					<label for="change_control_password_content" id='control-password-input'>Password:</label>
					<input type="password" id="change_control_password_content" name="change_control_password_content" value="" class="text ui-widget-content ui-corner-all">
					<label for="change_control_password_confirm"  id='control-password-confirm'>Password (confirm):</label>
					<input type="password" id="change_control_password_confirm" name="change_control_password_confirm" value="" class="text ui-widget-content ui-corner-all">
					<input type="submit" tabindex="-1" style="position:absolute; top:-1000px">
				</fieldset>
			</form>
		</div>

		<div id="change_players_password_dialog" title="Change 'players' password" hidden >
			<p class="change_players_password_dialog_tip"></p>
			<form action="" method="post">
				<fieldset>
					<label for="change_players_password_content" id='players-password-input'>Password:</label>
					<input type="password" id="change_players_password_content" name="change_players_password_content" value="" class="text ui-widget-content ui-corner-all">
					<label for="change_players_password_confirm" id='players-password-confirm'>Password (confirm):</label>
					<input type="password" id="change_players_password_confirm" name="change_players_password_confirm" value="" class="text ui-widget-content ui-corner-all">
					<input type="submit" tabindex="-1" style="position:absolute; top:-1000px">
				</fieldset>
			</form>
		</div>

		<div id="change_reboot_password_dialog" title="Change 'reboot' password" hidden >
			<p class="change_reboot_password_dialog_tip"></p>
			<form action="" method="post">
				<fieldset>
					<label for="change_reboot_password_content" id='reboot-password-input'>Password:</label>
					<input type="password" id="change_reboot_password_content" name="change_reboot_password_content" value="" class="text ui-widget-content ui-corner-all">
					<label for="change_reboot_password_confirm" id='reboot-password-confirm'>Password (confirm):</label>
					<input type="password" id="change_reboot_password_confirm" name="change_reboot_password_confirm" value="" class="text ui-widget-content ui-corner-all">
					<input type="submit" tabindex="-1" style="position:absolute; top:-1000px">
				</fieldset>
			</form>
		</div>

		<div id="add_control_key_dialog" title="Add 'control' SSH key" hidden >
			<p class="add_control_key_dialog_tip"></p>
			<p id='add-control-key-description'>Paste your public SSH key, which is usually contained in the file '~/.ssh/id_ed25519.pub' or '~/.ssh/id_rsa.pub' and begins with 'ssh-ed25519' or 'ssh-rsa'. Do not paste your private SSH key, as that can compromise your identity.</p>
			<form action="" method="post">
				<fieldset>
					<textarea name='add_control_key_text' id='add_control_key_text' placeholder='Typically starts with "ssh-ed25519" or "ssh-rsa..."' cols="60" rows="10"></textarea>
					<br/>&nbsp;<br/>
				</fieldset>
			</form>
		</div>

		<div id="add_players_key_dialog" title="Add 'players' SSH key" hidden >
			<p class="add_players_key_dialog_tip"></p>
			<p id='add-players-key-description'>Paste your public SSH key, which is usually contained in the file '~/.ssh/id_ed25519.pub' or '~/.ssh/id_rsa.pub' and begins with 'ssh-ed25519' or 'ssh-rsa'. Do not paste your private SSH key, as that can compromise your identity.</p>
			<form action="" method="post">
				<fieldset>
					<textarea name='add_players_key_text' id='add_players_key_text' placeholder='Typically starts with "ssh-ed25519" or "ssh-rsa..."' cols="60" rows="10"></textarea>
					<br/>&nbsp;<br/>
				</fieldset>
			</form>
		</div>

		<div id="add_reboot_key_dialog" title="Add 'reboot' SSH key" hidden >
			<p class="add_reboot_key_dialog_tip"></p>
			<p id='add-reboot-key-description'>Paste your public SSH key, which is usually contained in the file '~/.ssh/id_ed25519.pub' or '~/.ssh/id_rsa.pub' and begins with 'ssh-ed25519' or 'ssh-rsa'. Do not paste your private SSH key, as that can compromise your identity.</p>
			<form action="" method="post">
				<fieldset>
					<textarea name='add_reboot_key_text' id='add_reboot_key_text' placeholder='Typically starts with "ssh-ed25519" or "ssh-rsa..."' cols="60" rows="10"></textarea>
					<br/>&nbsp;<br/>
				</fieldset>
			</form>
		</div>

		<div id="revoke_control_keys_dialog" title='Revoke "control" keys?' hidden >
			<p><span class="ui-icon ui-icon-alert" style="float:left; margin:12px 12px 20px 0;"></span>
				<span id='revoke-control-keys-confirmation'>Are you sure you want to revoke all keys for "control" user?</span>
			</p>
		</div>

		<div id="revoke_players_keys_dialog" title='Revoke "players" keys?' hidden >
			<p><span class="ui-icon ui-icon-alert" style="float:left; margin:12px 12px 20px 0;"></span>
				<span id='revoke-players-keys-confirmation'>Are you sure you want to revoke all keys for "players" user?</span>
			</p>
		</div>

		<div id="revoke_reboot_keys_dialog" title='Revoke "reboot" keys?' hidden >
			<p><span class="ui-icon ui-icon-alert" style="float:left; margin:12px 12px 20px 0;"></span>
				<span id='revoke-reboot-keys-confirmation'>Are you sure you want to revoke all keys for "reboot" user?</span>
			</p>
		</div>

		<script>

			window.onload = function()
			{
				update_header_from_lang();

				init_change_control_password_dialog();
				init_add_control_key_dialog();
				init_revoke_control_keys_dialog();

				init_change_players_password_dialog();
				init_add_players_key_dialog();
				init_revoke_players_keys_dialog();

				init_change_reboot_password_dialog();
				init_add_reboot_key_dialog();
				init_revoke_reboot_keys_dialog();

				init_keep_tcp_port_check();


				if (localStorage.getItem("HytemLang") == "fr") {

					document.getElementById('ssh-special-accounts-title').innerHTML="Comptes SSH spéciaux";

					document.getElementById('control-account-title').innerHTML='<strong>Le compte "control"</strong>';
					document.getElementById('control-account-description').innerHTML='Le compte spécial "control" peut agir sur n\'importe quel équipement en se connectant avec SSH et en utilisant l\'ancienne API Hytem.';

					document.getElementById('players-account-title').innerHTML='<strong>Le compte "players"</strong>';
					document.getElementById('players-account-description').innerHTML='Le compte spécial "players" peut lancer ou arrêter des séquences sur n\'importe quel équipement.';

					document.getElementById('reboot-account-title').innerHTML='<strong>Le compte "reboot"</strong>';
					document.getElementById('reboot-account-description').innerHTML='Le compte spécial "reboot" peut redémarrer le système à distance.';

					document.getElementById('change_control_password').innerHTML='Changer de<br/>mot de passe';
					document.getElementById('add_control_key').innerHTML='Ajouter une<br/>clé SSH';
					document.getElementById('revoke_control_keys').innerHTML='Révoquer les<br/>clés SSH';

					document.getElementById('change_players_password').innerHTML='Changer de<br/>mot de passe';
					document.getElementById('add_players_key').innerHTML='Ajouter une<br/>clé SSH';
					document.getElementById('revoke_players_keys').innerHTML='Révoquer les<br/>clés SSH';

					document.getElementById('change_reboot_password').innerHTML='Changer de<br/>mot de passe';
					document.getElementById('add_reboot_key').innerHTML='Ajouter une<br/>clé SSH';
					document.getElementById('revoke_reboot_keys').innerHTML='Révoquer les<br/>clés SSH';

					document.getElementById('keep-tcp-port-label').innerHTML='Conserver les ports TCP accessibles avec Telnet';
					document.getElementById('option-needs-system-reboot').innerHTML = '<small>Cette option nécessite un redémarrage système</small>';

					document.getElementById('ui-id-1').innerHTML = 'Mot de passe compte "control"';
					document.getElementById('control-password-input').innerHTML = 'Mot de passe :';
					document.getElementById('control-password-confirm').innerHTML = 'Mot de passe (confirmation) :';
					document.getElementById('change-control-password-change').innerHTML = "<span class='ui-button-text'>Valider</span>";
					document.getElementById('change-control-password-cancel').innerHTML = "<span class='ui-button-text'>Annuler</span>";

					document.getElementById('ui-id-2').innerHTML = 'Ajout clé SSH';
					document.getElementById('add_control_key_text').placeholder = 'Commence généralement par "ssh-ed25519" ou "ssh-rsa..."';
					document.getElementById('add-control-key-description').innerHTML = "Copiez-collez votre clé SSH, qui se trouve habituellement dans le fichier '~/.ssh/id_ed25519.pub' ou '~/.ssh/id_rsa.pub' et commence par 'ssh-ed25519' ou 'ssh-rsa'. Ne copiez-collez pas votre clé SSH privée, ce serait une faille de sécurité.";
					document.getElementById('add-control-key-add').innerHTML = "<span class='ui-button-text'>Ajouter</span>";
					document.getElementById('add-control-key-cancel').innerHTML = "<span class='ui-button-text'>Annuler</span>";

					document.getElementById('ui-id-3').innerHTML = 'Révocation clés SSH';
					document.getElementById('revoke-control-key-remove').innerHTML = "<span class='ui-button-text'>Effacer clés</span>";
					document.getElementById('revoke-control-key-cancel').innerHTML = "<span class='ui-button-text'>Annuler</span>";
					document.getElementById('revoke-control-keys-confirmation').innerHTML = "Êtes-vous sûr de vouloir effacer toutes les clés du compte 'control'&nbsp;?";

					document.getElementById('ui-id-4').innerHTML = 'Mot de passe compte "players"';
					document.getElementById('players-password-input').innerHTML = 'Mot de passe :';
					document.getElementById('players-password-confirm').innerHTML = 'Mot de passe (confirmation) :';
					document.getElementById('change-players-password-change').innerHTML = "<span class='ui-button-text'>Valider</span>";
					document.getElementById('change-players-password-cancel').innerHTML = "<span class='ui-button-text'>Annuler</span>";

					document.getElementById('ui-id-5').innerHTML = 'Ajout clé SSH';
					document.getElementById('add_players_key_text').placeholder = 'Commence généralement par "ssh-ed25519" ou "ssh-rsa..."';
					document.getElementById('add-players-key-description').innerHTML = "Copiez-collez votre clé SSH, qui se trouve habituellement dans le fichier '~/.ssh/id_ed25519.pub' ou '~/.ssh/id_rsa.pub' et commence par 'ssh-ed25519' ou 'ssh-rsa'. Ne copiez-collez pas votre clé SSH privée, ce serait une faille de sécurité.";
					document.getElementById('add-players-key-add').innerHTML = "<span class='ui-button-text'>Ajouter</span>";
					document.getElementById('add-players-key-cancel').innerHTML = "<span class='ui-button-text'>Annuler</span>";

					document.getElementById('ui-id-6').innerHTML = 'Révocation clés SSH';
					document.getElementById('revoke-players-key-remove').innerHTML = "<span class='ui-button-text'>Effacer clés</span>";
					document.getElementById('revoke-players-key-cancel').innerHTML = "<span class='ui-button-text'>Annuler</span>";
					document.getElementById('revoke-players-keys-confirmation').innerHTML = "Êtes-vous sûr de vouloir effacer toutes les clés du compte 'players'&nbsp;?";

					document.getElementById('ui-id-7').innerHTML = 'Mot de passe compte "reboot"';
					document.getElementById('reboot-password-input').innerHTML = 'Mot de passe :';
					document.getElementById('reboot-password-confirm').innerHTML = 'Mot de passe (confirmation) :';
					document.getElementById('change-reboot-password-change').innerHTML = "<span class='ui-button-text'>Valider</span>";
					document.getElementById('change-reboot-password-cancel').innerHTML = "<span class='ui-button-text'>Annuler</span>";

					document.getElementById('ui-id-8').innerHTML = 'Ajout clé SSH';
					document.getElementById('add_reboot_key_text').placeholder = 'Commence généralement par "ssh-ed25519" ou "ssh-rsa..."';
					document.getElementById('add-reboot-key-description').innerHTML = "Copiez-collez votre clé SSH, qui se trouve habituellement dans le fichier '~/.ssh/id_ed25519.pub' ou '~/.ssh/id_rsa.pub' et commence par 'ssh-ed25519' ou 'ssh-rsa'. Ne copiez-collez pas votre clé SSH privée, ce serait une faille de sécurité.";
					document.getElementById('add-reboot-key-add').innerHTML = "<span class='ui-button-text'>Ajouter</span>";
					document.getElementById('add-reboot-key-cancel').innerHTML = "<span class='ui-button-text'>Annuler</span>";

					document.getElementById('ui-id-9').innerHTML = 'Révocation clés SSH';
					document.getElementById('revoke-reboot-key-remove').innerHTML = "<span class='ui-button-text'>Effacer clés</span>";
					document.getElementById('revoke-reboot-key-cancel').innerHTML = "<span class='ui-button-text'>Annuler</span>";
					document.getElementById('revoke-reboot-keys-confirmation').innerHTML = "Êtes-vous sûr de vouloir effacer toutes les clés du compte 'reboot'&nbsp;?";

				}
			}



			function init_change_control_password_dialog()
			{
				var form;
				var dialog;

				dialog = $("#change_control_password_dialog").dialog({
					autoOpen: false,
					height: 450,
					width: 350,
					modal: true,
					buttons: {
						"Change": {
							id: 'change-control-password-change',
							text: "Change",
							click: change_control_password_dialog_validate,
						},
						"Cancel": {
							id: 'change-control-password-cancel',
							text: "Cancel",
							click : function()
							{
								dialog.dialog("close");
							},
						},
					},
					close: function() {
						form[0].reset();
					}
				});

				form = dialog.find("form").on("submit", function(event) {
					event.preventDefault();
					change_control_password_dialog_validate();
				});
			}



			function init_change_players_password_dialog()
			{
				var form;
				var dialog;

				dialog = $("#change_players_password_dialog").dialog({
					autoOpen: false,
					height: 450,
					width: 350,
					modal: true,
					buttons: {
						"Change": {
							id: 'change-players-password-change',
							text: "Change",
							click: change_players_password_dialog_validate,
						},
						"Cancel": {
							id: 'change-players-password-cancel',
							text: "Cancel",
							click : function()
							{
								dialog.dialog("close");
							},
						},
					},
					close: function() {
						form[0].reset();
					}
				});

				form = dialog.find("form").on("submit", function(event) {
					event.preventDefault();
					change_players_password_dialog_validate();
				});
			}



			function init_change_reboot_password_dialog()
			{
				var form;
				var dialog;

				dialog = $("#change_reboot_password_dialog").dialog({
					autoOpen: false,
					height: 450,
					width: 350,
					modal: true,
					buttons: {
						"Change": {
							id: 'change-reboot-password-change',
							text: "Change",
							click: change_reboot_password_dialog_validate,
						},
						"Cancel": {
							id: 'change-reboot-password-cancel',
							text: "Cancel",
							click : function()
							{
								dialog.dialog("close");
							},
						},
					},
					close: function() {
						form[0].reset();
					}
				});

				form = dialog.find("form").on("submit", function(event) {
					event.preventDefault();
					change_reboot_password_dialog_validate();
				});
			}



			function init_add_control_key_dialog()
			{
				var form;
				var dialog;

				dialog = $("#add_control_key_dialog").dialog({
					autoOpen: false,
					height: 520,
					width: 700,
					modal: true,
					buttons: {
						"Add key": {
							id: 'add-control-key-add',
							text: "Add key",
							click: add_control_key_dialog_validate,
						},
						"Cancel": {
							id: 'add-control-key-cancel',
							text: "Cancel",
							click: function() {
								dialog.dialog("close");
							},
						},
					},
					close: function() {
						form[0].reset();
					}
				});

				form = dialog.find("form").on("submit", function(event) {
					event.preventDefault();
					add_control_key_dialog_validate();
				});
			}



			function init_add_players_key_dialog()
			{
				var form;
				var dialog;

				dialog = $("#add_players_key_dialog").dialog({
					autoOpen: false,
					height: 520,
					width: 700,
					modal: true,
					buttons: {
						"Add key": {
							id: 'add-players-key-add',
							text: "Add key",
							click: add_players_key_dialog_validate,
						},
						"Cancel": {
							id: 'add-players-key-cancel',
							text: "Cancel",
							click: function() {
								dialog.dialog("close");
							}
						},
					},
					close: function() {
						form[0].reset();
					}
				});

				form = dialog.find("form").on("submit", function(event) {
					event.preventDefault();
					add_players_key_dialog_validate();
				});
			}



			function init_add_reboot_key_dialog()
			{
				var form;
				var dialog;

				dialog = $("#add_reboot_key_dialog").dialog({
					autoOpen: false,
					height: 520,
					width: 700,
					modal: true,
					buttons: {
						"Add key": {
							id: 'add-reboot-key-add',
							text: "Add key",
							click: add_reboot_key_dialog_validate,
						},
						"Cancel": {
							id: 'add-reboot-key-cancel',
							text: "Cancel",
							click: function() {
								dialog.dialog("close");
							}
						},
					},
					close: function() {
						form[0].reset();
					}
				});

				form = dialog.find("form").on("submit", function(event) {
					event.preventDefault();
					add_reboot_key_dialog_validate();
				});
			}



			function init_revoke_control_keys_dialog()
			{
				var dialog;
				dialog = $( "#revoke_control_keys_dialog" ).dialog({
					autoOpen: false,
					resizable: false,
					height: "auto",
					width: 400,
					modal: true,
					buttons: {
						"Remove keys": {
							id: 'revoke-control-key-remove',
							text: "Remove keys",
							click: function() {
								do_revoke_control_keys();
								$( this ).dialog( "close" );
							},
						},
						"Cancel": {
							id: 'revoke-control-key-cancel',
							text: "Cancel",
							click: function() {
								$( this ).dialog( "close" );
							},
						},
					}
				});
			}



			function init_revoke_players_keys_dialog()
			{
				var dialog;
				dialog = $( "#revoke_players_keys_dialog" ).dialog({
					autoOpen: false,
					resizable: false,
					height: "auto",
					width: 400,
					modal: true,
					buttons: {
						"Remove keys": {
							id: 'revoke-players-key-remove',
							text: "Remove keys",
							click: function() {
								do_revoke_players_keys();
								$( this ).dialog( "close" );
							},
						},
						"Cancel": {
							id: 'revoke-players-key-cancel',
							text: "Cancel",
							click: function() {
								$( this ).dialog( "close" );
							},
						},
					}
				});
			}



			function init_revoke_reboot_keys_dialog()
			{
				var dialog;
				dialog = $( "#revoke_reboot_keys_dialog" ).dialog({
					autoOpen: false,
					resizable: false,
					height: "auto",
					width: 400,
					modal: true,
					buttons: {
						"Remove keys": {
							id: 'revoke-reboot-key-remove',
							text: "Remove keys",
							click: function() {
								do_revoke_reboot_keys();
								$( this ).dialog( "close" );
							},
						},
						"Cancel": {
							id: 'revoke-reboot-key-cancel',
							text: "Cancel",
							click: function() {
								$( this ).dialog( "close" );
							},
						},
					}
				});
			}



			function init_keep_tcp_port_check()
			{
				var xhr = get_xhr_object();
				if (xhr == null)
					return;

				xhr.onreadystatechange = function()
				{
					if ((xhr.readyState == 4) && (xhr.status == 200)) {

						var response = xhr.responseText;
						if (response == "1")
							document.getElementById('keep-tcp-port-check').checked = true;
						else
							document.getElementById('keep-tcp-port-check').checked = false;
					};
				}
				xhr.open("GET", "action/get-keep-tcp-port.php", true);
				xhr.send();
			}



			function change_control_password_cb()
			{
				$("#change_control_password_dialog").dialog("open");
				$(".change_control_password_dialog_tip").text("");
				$(".change_control_password_dialog_tip").removeClass("ui-state-highlight");
				$("#change_control_password_text").removeClass("ui-state-error");
				$("#change_control_password_content").removeClass("ui-state-error");
				$("#change_control_password_confirm").removeClass("ui-state-error");
			}



			function change_players_password_cb()
			{
				$("#change_players_password_dialog").dialog("open");
				$(".change_players_password_dialog_tip").text("");
				$(".change_players_password_dialog_tip").removeClass("ui-state-highlight");
				$("#change_players_password_text").removeClass("ui-state-error");
				$("#change_players_password_content").removeClass("ui-state-error");
				$("#change_players_password_confirm").removeClass("ui-state-error");
			}



			function change_reboot_password_cb()
			{
				$("#change_reboot_password_dialog").dialog("open");
				$(".change_reboot_password_dialog_tip").text("");
				$(".change_reboot_password_dialog_tip").removeClass("ui-state-highlight");
				$("#change_reboot_password_text").removeClass("ui-state-error");
				$("#change_reboot_password_content").removeClass("ui-state-error");
				$("#change_reboot_password_confirm").removeClass("ui-state-error");
			}



			function add_control_key_cb()
			{
				$("#add_control_key_dialog").dialog("open");
				$(".add_control_key_dialog_tip").text("");
				$(".add_control_key_dialog_tip").removeClass("ui-state-highlight");
				$("#add_control_key_text").removeClass("ui-state-error");
			}



			function add_players_key_cb()
			{
				$("#add_players_key_dialog").dialog("open");
				$(".add_players_key_dialog_tip").text("");
				$(".add_players_key_dialog_tip").removeClass("ui-state-highlight");
				$("#add_players_key_text").removeClass("ui-state-error");
			}



			function add_reboot_key_cb()
			{
				$("#add_reboot_key_dialog").dialog("open");
				$(".add_reboot_key_dialog_tip").text("");
				$(".add_reboot_key_dialog_tip").removeClass("ui-state-highlight");
				$("#add_reboot_key_text").removeClass("ui-state-error");
			}



			function revoke_control_keys_cb()
			{
				$("#revoke_control_keys_dialog").dialog("open");
			}



			function revoke_players_keys_cb()
			{
				$("#revoke_players_keys_dialog").dialog("open");
			}



			function revoke_reboot_keys_cb()
			{
				$("#revoke_reboot_keys_dialog").dialog("open");
			}



			function change_control_password_dialog_validate()
			{
				var password_widget = $("#change_control_password_content");
				var confirm_widget = $("#change_control_password_confirm");

				password_widget.removeClass("ui-state-error");
				confirm_widget.removeClass("ui-state-error");

				if (password_widget.val().length  < 1) {
					if (localStorage.getItem("HytemLang") == "fr")
						change_control_password_dialog_tips("Le mot de passe ne doit pas être vide.");
					else
						change_control_password_dialog_tips("Password can't be empty.");

					password_widget.addClass("ui-state-error");
					return false;
				}

				if (password_widget.val() != confirm_widget.val()) {
					if (localStorage.getItem("HytemLang") == "fr")
						change_control_password_dialog_tips("Le mot de passe et sa confirmation sont différents.");
					else
						change_control_password_dialog_tips("Password and confirmation fields are different.");
					password_widget.addClass("ui-state-error");
					confirm_widget.addClass("ui-state-error");
					return false;
				}

				do_change_control_password(password_widget.val());

				$("#change_control_password_dialog").dialog("close");

				return true;
			}



			function change_players_password_dialog_validate()
			{
				var password_widget = $("#change_players_password_content");
				var confirm_widget = $("#change_players_password_confirm");

				password_widget.removeClass("ui-state-error");
				confirm_widget.removeClass("ui-state-error");

				if (password_widget.val().length  < 1) {
					if (localStorage.getItem("HytemLang") == "fr")
						change_players_password_dialog_tips("Le mot de passe ne doit pas être vide.");
					else
						change_players_password_dialog_tips("Password can't be empty.");
					password_widget.addClass("ui-state-error");
					return false;
				}

				if (password_widget.val() != confirm_widget.val()) {
					if (localStorage.getItem("HytemLang") == "fr")
						change_players_password_dialog_tips("Le mot de passe et sa confirmation sont différents.");
					else
						change_players_password_dialog_tips("Password and confirmation fields are different.");

					password_widget.addClass("ui-state-error");
					confirm_widget.addClass("ui-state-error");
					return false;
				}

				do_change_players_password(password_widget.val());

				$("#change_players_password_dialog").dialog("close");

				return true;
			}



			function change_reboot_password_dialog_validate()
			{
				var password_widget = $("#change_reboot_password_content");
				var confirm_widget = $("#change_reboot_password_confirm");

				password_widget.removeClass("ui-state-error");
				confirm_widget.removeClass("ui-state-error");

				if (password_widget.val().length  < 1) {
					if (localStorage.getItem("HytemLang") == "fr")
						change_reboot_password_dialog_tips("Le mot de passe ne doit pas être vide.");
					else
						change_reboot_password_dialog_tips("Password can't be empty.");
					password_widget.addClass("ui-state-error");
					return false;
				}

				if (password_widget.val() != confirm_widget.val()) {
					if (localStorage.getItem("HytemLang") == "fr")
						change_reboot_password_dialog_tips("Le mot de passe et sa confirmation sont différents.");
					else
						change_reboot_password_dialog_tips("Password and confirmation fields are different.");

					password_widget.addClass("ui-state-error");
					confirm_widget.addClass("ui-state-error");
					return false;
				}

				do_change_reboot_password(password_widget.val());

				$("#change_reboot_password_dialog").dialog("close");

				return true;
			}



			function add_control_key_dialog_validate()
			{
				var key_widget = $("#add_control_key_text");

				if (key_widget.val().length < 1) {
					if (localStorage.getItem("HytemLang") == "fr")
						add_control_key_dialog_tips("La clé ne doit pas être vide.");
					else
						add_control_key_dialog_tips("Key can not be empty.");
					key_widget.addClass("ui-state-error");
					return false;
				}
				do_add_control_key(key_widget.val());

				return true;
			}



			function add_players_key_dialog_validate()
			{
				var key_widget = $("#add_players_key_text");

				if (key_widget.val().length < 1) {
					if (localStorage.getItem("HytemLang") == "fr")
						add_players_key_dialog_tips("La clé ne doit pas être vide.");
					else
						add_players_key_dialog_tips("Key can not be empty.");
					key_widget.addClass("ui-state-error");
					return false;
				}
				do_add_players_key(key_widget.val());

				$("#add_players_key_dialog").dialog("close");

				return true;
			}



			function add_reboot_key_dialog_validate()
			{
				var key_widget = $("#add_reboot_key_text");

				if (key_widget.val().length < 1) {
					if (localStorage.getItem("HytemLang") == "fr")
						add_reboot_key_dialog_tips("La clé ne doit pas être vide.");
					else
						add_reboot_key_dialog_tips("Key can not be empty.");
					key_widget.addClass("ui-state-error");
					return false;
				}
				do_add_reboot_key(key_widget.val());

				$("#add_reboot_key_dialog").dialog("close");

				return true;
			}



			function change_control_password_dialog_tips(message)
			{
				$(".change_control_password_dialog_tip").text(message).addClass("ui-state-highlight");
			}



			function change_players_password_dialog_tips(message)
			{
				$(".change_players_password_dialog_tip").text(message).addClass("ui-state-highlight");
			}



			function change_reboot_password_dialog_tips(message)
			{
				$(".change_reboot_password_dialog_tip").text(message).addClass("ui-state-highlight");
			}



			function add_control_key_dialog_tips(message)
			{
				$(".add_control_key_dialog_tip").text(message).addClass("ui-state-highlight");
			}



			function add_players_key_dialog_tips(message)
			{
				$(".add_players_key_dialog_tip").text(message).addClass("ui-state-highlight");
			}



			function add_reboot_key_dialog_tips(message)
			{
				$(".add_reboot_key_dialog_tip").text(message).addClass("ui-state-highlight");
			}



			function do_change_control_password(password)
			{
				var xhr = get_xhr_object();
				if (xhr == null)
					return;
				xhr.open("GET", "cgi-bin/set-system-password?usr=control&pwd=" + password, true);
				xhr.send();
			}



			function do_change_players_password(password)
			{
				var xhr = get_xhr_object();
				if (xhr == null)
					return;
				xhr.open("GET", "cgi-bin/set-system-password?usr=players&pwd=" + password, true);
				xhr.send();
			}



			function do_change_reboot_password(password)
			{
				var xhr = get_xhr_object();
				if (xhr == null)
					return;
				xhr.open("GET", "cgi-bin/set-system-password?usr=reboot&pwd=" + password, true);
				xhr.send();
			}



			function do_add_control_key(key)
			{
				var xhr = get_xhr_object();
				if (xhr == null)
					return;
				xhr.onreadystatechange = function() {
					if (xhr.readyState == 4) {
						if (xhr.status == 200) {
							if (xhr.responseText.length > 0) {
								add_control_key_dialog_tips(xhr.responseText);
							} else {
								$("#add_control_key_dialog").dialog("close");
							}
						}
					}
				}
				xhr.open("GET", "cgi-bin/add-ssh-key?usr=control&key=" + key, true);
				xhr.send();
			}



			function do_add_players_key(key)
			{
				var xhr = get_xhr_object();
				if (xhr == null)
					return;
				xhr.open("GET", "cgi-bin/add-ssh-key?usr=players&key=" + key, true);
				xhr.send();
			}



			function do_add_reboot_key(key)
			{
				var xhr = get_xhr_object();
				if (xhr == null)
					return;
				xhr.open("GET", "cgi-bin/add-ssh-key?usr=reboot&key=" + key, true);
				xhr.send();
			}



			function do_revoke_control_keys(password)
			{
				var xhr = get_xhr_object();
				if (xhr == null)
					return;
				xhr.open("GET", "cgi-bin/revoke-ssh-keys?usr=control", true);
				xhr.send();
			}



			function do_revoke_players_keys(password)
			{
				var xhr = get_xhr_object();
				if (xhr == null)
					return;
				xhr.open("GET", "cgi-bin/revoke-ssh-keys?usr=players", true);
				xhr.send();
			}



			function do_revoke_reboot_keys(password)
			{
				var xhr = get_xhr_object();
				if (xhr == null)
					return;
				xhr.open("GET", "cgi-bin/revoke-ssh-keys?usr=reboot", true);
				xhr.send();
			}



			function keep_tcp_port_check_changed()
			{
                                var xhr;
                                var line;

                                xhr = get_xhr_object();
                                if (xhr != null) {

                                        if (document.getElementById('keep-tcp-port-check').checked) {
                                                line='action/set-keep-tcp-port.php?keep';
                                        } else {
                                                line='action/set-keep-tcp-port.php?no';
                                        }
                                        xhr.open("GET", line, true);
                                        xhr.send();
                                }
                        }

		</script>
	</body>
</html>
