<?php
	/*
		Users manager for the Hytem device control system.

		Design and implementation by Logilin (www.logilin.fr) for Hytem (www.hytem.net)
	*/

	require('hytem-header.php');

	if (! (($Multiusers && $Admin_logged) || ($Factory_mode)))
		header("Location: http:/index.php");

?>
<!DOCTYPE html>
<html>
	<head>
		<?php  fill_html_head_block(); ?>

		<style>
			label, input { display:block; }
			input.text { margin-bottom:12px; width:95%; padding: .4em; }
			fieldset { padding:0; border:0; margin-top:25px; }
			h1 { font-size: 1.2em; margin: .6em 0; }
			.ui-dialog .ui-state-error { padding: .3em; }
			.validateTips { border: 1px solid transparent; padding: 0.3em; }
		</style>
	</head>

	<body onselectstart="return false;" oncontextmenu="return false;"  style='overflow-y: scroll; overflow-x: auto; width: 99%;' >

		<?php fill_html_header_block("Users setup"); ?>

		<?php fill_tabs_block("users", ""); ?>

		<div class="content">
			<table id="users_manager_table">
				<tr>
					<td class="users_manager_action">
						<select SIZE=10 id="users_list" onchange="users_list_selection_changed_callback();">
						</select>
					</td>
					<td>
						<table>
							<tr>
								<td class="users_manager_action">
									<button type="button" class="manager_button" id="add_user_button" onclick="add_user_button_callback();">Add</button>
								</td>
							</tr><tr>
								<td class="users_manager_action">
									<button type="button" class="manager_button" id="delete_user_button" onclick="delete_user_button_callback();">Delete</button>
								</td>
							</tr><tr>
								<td class="users_manager_action">
									<button type="button" class="manager_button" id="change_password_button" onclick="change_password_button_callback();">Change password</button>
								</td>
							</tr>
							</tr><tr>
								<td class="users_manager_action">
									<label for="user_admin_checkbox" id="user_admin_label">Administrator</label>
									<input type="checkbox" class="manager_button" id="user_admin_checkbox" onclick="change_user_admin_callback();">
								</td>
							</tr>
							<?php
								if ($Factory_mode) {
									echo '</tr><tr>';
									echo '  <td class="users_manager_action">';
									echo '    <label for="user_factory_checkbox" id="user_factory_label">Factory</label>';
									echo '    <input type="checkbox" class="manager_button" id="user_factory_checkbox" onclick="change_user_factory_callback();">';
									echo '  </td>';
								}
							?>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</div>

		<div class="content">
			<table id="users_manager_table">
				<tr>
					<td class="users_manager_action">
						<button type="button" class="manager_button" id="save_button" onclick="save_callback();">Save changes</button>
					</td>
				</tr>
			</table>
		</div>

		<?php
			unset($output);
			exec("/home/www/cgi-bin/get-number-of-groups", $output, $retval);
			$nb_groups = (int)($output[2]);

			unset($output);
			exec("/home/www/cgi-bin/get-devices-per-group", $output, $retval);
			$nb_devices_per_group = (int)($output[2]);
		?>

		<div class="content">
			<?php
				for ($group = 0; $group < $nb_groups; $group++) {
					echo "<table id='group-table-".$group."' class='users_devices_table'>";
						echo "<tr>";
							echo "<td id='td-grp-".$group."'></td>";
							echo "<td>";
								echo "<table id='users-dev-table-".$group."'>";
									echo "<tr>";
										for ($dev = 0; $dev < ($nb_devices_per_group / 2); $dev ++) {
											echo "<td class='users_device_action'>";
											echo "<label id='lbl-" . $group . "-" . $dev ."' for='ck-" . $group . "-" . $dev ."'></label>";
											echo "<input type='checkbox' id='ck-" . $group . "-" . $dev ."' onclick='change_permission_callback(".$group.",".$dev.");'/>";
											echo "</td>";
										}
									echo "</tr>";
									echo "<tr>";
										for ($dev = floor(($nb_devices_per_group + 1)/ 2); $dev < $nb_devices_per_group; $dev ++) {
											echo "<td class='users_device_action'>";
											echo "<label id='lbl-" . $group . "-" . $dev ."' for='ck-" . $group . "-" . $dev ."'></label>";
											echo "<input type='checkbox' id='ck-" . $group . "-" . $dev ."' onclick='change_permission_callback(".$group.",".$dev.");'/>";
											echo "</td>";
										}
									echo "</tr>";
								echo "</table>";
							echo "</td>";
							echo "<td>";
							echo "<button class='users_devices_button' type='button' id='all-devices-button-".$group."' onclick='all_devices_button_callback(".$group.");'>All</button>";
							echo "<br/><br/>";
							echo "<button class='users_devices_button' type='button' id='no-devices-button-".$group."' onclick='none_devices_button_callback(".$group.");'>None</button>";
							echo "</td>";
						echo "</tr>";
					echo "</table>\n";
				}
			?>
		</div>


		<div id="add_user_dialog" title="Add a user" hidden >
			<p class="add_user_dialog_tip"></p>
			<form action="" method="post">
				<fieldset>
					<label for="add_user_login">Login:</label>
					<input type="text" id="add_user_login" name="add_user_login" value="" class="text ui-widget-content ui-corner-all">
					<label for="add_user_password" id="add_user_password_label">Password:</label>
					<input type="password" id="add_user_password" name="add_user_password" value="" class="text ui-widget-content ui-corner-all">
					<label for="add_user_confirm_password" id="add_user_confirm_password_label">Password (confirm):</label>
					<input type="password" id="add_user_confirm_password" name="add_user_confirm_password" value="" class="text ui-widget-content ui-corner-all">
					<label for="add_user_admin" id="add_user_admin_label">Administrator:</label>
					<input type="checkbox" id="add_user_admin" name="add_user_admin" >
					<input type="submit" tabindex="-1" style="position:absolute; top:-1000px">
				</fieldset>
			</form>
		</div>


		<div id="delete_user_dialog" title="Delete a user?" hidden >
			<p><span class="ui-icon ui-icon-alert" style="float:left; margin:12px 12px 20px 0;"></span><span id='delete-user-dialog-confirm'>Are you sure you want to delete user ?</span></p>
		</div>


		<div id="change_password_dialog" title="Change user password" hidden >
			<p class="change_password_dialog_tip"></p>
			<form action="" method="post">
				<fieldset>
					<label for="change_password_password" id="change_password_password_label">Password:</label>
					<input type="password" id="change_password_password" name="change_password_password" value="" class="text ui-widget-content ui-corner-all">
					<label for="change_password_confirm_password"  id="change_password_confirm_label">Password (confirm):</label>
					<input type="password" id="change_password_confirm_password" name="change_password_confirm_password" value="" class="text ui-widget-content ui-corner-all">
					<input type="submit" tabindex="-1" style="position:absolute; top:-1000px">
				</fieldset>
			</form>
		</div>


		<script type="text/javascript">

			var Users;
			var Nb_users = 0;

			var Nb_groups =  <?php echo $nb_groups; ?>;
			var Groups_names = [];

			var Nb_devices_per_group = <?php echo $nb_devices_per_group;?>;
			var Devices_names = [];


			function User(new_name, new_id, new_type, new_permissions)
			{
				this.user_name = new_name;
				this.user_id   = new_id;
				this.user_type = new_type;
				this.user_permissions = new Array;

				for (var i = 0; i < new_permissions.length; i++ ) {
					this.user_permissions[i] = new_permissions.charAt(i);
				}
				for (var i = new_permissions.length; i < Nb_groups * Nb_devices_per_group; i ++) {
					this.user_permissions[i] = "0";
				}
			}



			window.onload = function()
			{
				update_header_from_lang();

				init_add_user_dialog();
				init_delete_user_dialog();
				init_change_password_dialog();

				if (localStorage.getItem("HytemLang") == "fr") {
					document.getElementById('add_user_button').innerHTML = "Ajouter";
					document.getElementById('delete_user_button').innerHTML = "Supprimer";
					document.getElementById('change_password_button').innerHTML = "Mot de passe";
					document.getElementById('user_admin_label').innerHTML = "Administrateur";
					try {
						document.getElementById('user_factory_label').innerHTML = "Usine";
					} catch {

					}

					document.getElementById('save_button').innerHTML = "Enregistrer modifications";

					document.getElementById('ui-id-1').innerHTML = 'Ajout utilisateur';
					document.getElementById('add_user_password_label').innerHTML = "Mot de passe";
					document.getElementById('add_user_confirm_password_label').innerHTML = "Mot de passe (confirm.)";
					document.getElementById('add_user_admin_label').innerHTML = "Administrateur";

					document.getElementById('ui-id-2').innerHTML = 'Suppression utilisateur';
					document.getElementById('delete-user-dialog-confirm').innerHTML = "Êtes-vous sûr de vouloir supprimer l'utilisateur&nbsp;?";

					document.getElementById('ui-id-3').innerHTML = 'Mot de passe';
					document.getElementById('change_password_password_label').innerHTML = 'Mot de passe';
					document.getElementById('change_password_confirm_label').innerHTML = 'Mot de passe (confirm.)';

					document.getElementById('add-user-dialog-add').innerHTML = "<span class='ui-button-text'>Ajouter</span>";
					document.getElementById('add-user-dialog-cancel').innerHTML = "<span class='ui-button-text'>Annuler</span>";

					document.getElementById('delete-user-dialog-delete').innerHTML = "<span class='ui-button-text'>Supprimer</span>";
					document.getElementById('delete-user-dialog-cancel').innerHTML = "<span class='ui-button-text'>Annuler</span>";
					document.getElementById('change-password-dialog-change').innerHTML = "<span class='ui-button-text'>Valider</span>";
					document.getElementById('change-password-dialog-cancel').innerHTML = "<span class='ui-button-text'>Annuler</span>";

					for (var g = 0; g < Nb_groups; g ++) {
						document.getElementById('all-devices-button-' + g).innerHTML = "Tous";
						document.getElementById('no-devices-button-' + g).innerHTML = "Aucun";
					}

				}

				load_groups_and_devices_names_arrays();

				load_users();
			}



			function init_add_user_dialog()
			{
				var form;
				var dialog;

				dialog = $("#add_user_dialog").dialog({
					autoOpen: false,
					height: 450,
					width: 350,
					modal: true,
					buttons: {
						"Add": {
							id: "add-user-dialog-add",
							text: "Add",
							click: add_user_dialog_validate,
						},
						"Cancel": {
							id: "add-user-dialog-cancel",
							text: "Cancel",
							click: function() {
								dialog.dialog("close");
							},
						},
					},
					close: function() {
						form[ 0 ].reset();
					}
				});

				form = dialog.find("form").on("submit", function(event) {
					event.preventDefault();
					add_user_dialog_validate();
				});
			}



			function init_delete_user_dialog()
			{
				var dialog;
				dialog = $( "#delete_user_dialog" ).dialog({
					autoOpen: false,
					resizable: false,
					height: "auto",
					width: 400,
					modal: true,
					buttons: {
						"Delete": {
							text: "Delete",
							id: "delete-user-dialog-delete",
							click: function() {
								do_delete_user();
								$( this ).dialog( "close" );
							},
						},
						"Cancel": {
							text: "Cancel",
							id: "delete-user-dialog-cancel",
							click: function() {
								$( this ).dialog( "close" );
							},
						},
					}
				});
			}



			function init_change_password_dialog()
			{
				var form;
				var dialog;

				dialog = $("#change_password_dialog").dialog({
					autoOpen: false,
					height: 450,
					width: 350,
					modal: true,
					buttons: {
						"Change": {
							text: "Change",
							id: "change-password-dialog-change",
							click: change_password_dialog_validate,
						},
						"Cancel": {
							text: "Cancel",
							id: "change-password-dialog-cancel",
							click: function() {
								dialog.dialog("close");
							},
						},
					},
					close: function() {
						form[ 0 ].reset();
					}
				});

				form = dialog.find("form").on("submit", function(event) {
					event.preventDefault();
					change_password_dialog_validate();
				});
			}



			function add_user_button_callback()
			{
				$("#add_user_dialog").dialog("open");
			}



			function delete_user_button_callback()
			{
				var selected_user = document.getElementById("users_list").selectedIndex;
				if (selected_user >= 0) {

					if ((Users[selected_user].user_type == 1)
					 && (number_of_admins() == 1)) {
						if (localStorage.getItem("HytemLang") == "fr") {
							alert("Vous ne pouvez pas supprimer le dernier compte admninistrateur.");
						} else {
							alert("You can't delete the last administrator account.");
						}
						return;
					}

					$("#delete_user_dialog").dialog("open");
				}
			}



			function change_password_button_callback()
			{
				if (document.getElementById("users_list").selectedIndex >= 0)
					$("#change_password_dialog").dialog("open");
			}



			function add_user_dialog_validate()
			{
				var login_widget = $("#add_user_login");
				var password_widget = $("#add_user_password");
				var confirm_widget = $("#add_user_confirm_password");
				var admin_widget = document.getElementById("add_user_admin");

				login_widget.removeClass("ui-state-error");
				password_widget.removeClass("ui-state-error");
				confirm_widget.removeClass("ui-state-error");

				if (login_widget.val().length < 1) {
					if (localStorage.getItem("HytemLang") == "fr") {
						update_add_user_dialog_tips("Le champ 'login' ne doit pas être vide.");
					} else {
						update_add_user_dialog_tips("Login can't be empty.");
					}
					login_widget.addClass("ui-state-error");
					return false;
				}

				for (var i = 0; i < Nb_users; i ++) {
					if (login_widget.val() == Users[i].login) {
						login_widget.addClass("ui-state-error");
						if (localStorage.getItem("HytemLang") == "fr") {
							update_add_user_dialog_tips("Cet utilisateur existe déjà.");
						} else {
							update_add_user_dialog_tips("This user already exists.");
						}
						return false;
					}
				}

				if (password_widget.val().length  < 1) {
					if (localStorage.getItem("HytemLang") == "fr") {
						update_add_user_dialog_tips("Le mot de passe ne doit pas être vide.");
					} else {
						update_add_user_dialog_tips("Password can't be empty.");
					}
					password_widget.addClass("ui-state-error");
					return false;
				}

				if (password_widget.val() != confirm_widget.val()) {
					if (localStorage.getItem("HytemLang") == "fr") {
						update_add_user_dialog_tips("Le mot de passe et sa confirmation sont différents.");
					} else {
						update_add_user_dialog_tips("Password and confirmation fields are different.");
					}
					password_widget.addClass("ui-state-error");
					confirm_widget.addClass("ui-state-error");
					return false;
				}

				do_add_user(login_widget.val(), password_widget.val(), admin_widget.checked);

				$("#add_user_dialog").dialog("close");

				refresh_users_list();

				return true;
			}



			function change_password_dialog_validate()
			{
				var password_widget = $("#change_password_password");
				var confirm_widget = $("#change_password_confirm_password");

				password_widget.removeClass("ui-state-error");
				confirm_widget.removeClass("ui-state-error");

				if (password_widget.val().length  < 1) {
					if (localStorage.getItem("HytemLang") == "fr") {
						update_change_password_dialog_tips("Le mot de passe ne doit pas être vide.");
					} else {
						update_change_password_dialog_tips("Password can't be empty.");
					}
					password_widget.addClass("ui-state-error");
					return false;
				}

				if (password_widget.val() != confirm_widget.val()) {
					if (localStorage.getItem("HytemLang") == "fr") {
						update_change_password_dialog_tips("Le mot de passe et sa confirmation sont différents.");
					} else {
						update_change_password_dialog_tips("Password and confirmation fields are different.");
					}
					password_widget.addClass("ui-state-error");
					confirm_widget.addClass("ui-state-error");
					return false;
				}

				do_change_password(password_widget.val());

				$("#change_password_dialog").dialog("close");

				return true;
			}



			function update_add_user_dialog_tips(message)
			{
				$(".add_user_dialog_tip").text(message).addClass("ui-state-highlight");
				setTimeout(function() {
					$(".add_user_dialog_tip").removeClass("ui-state-highlight", 1500);
				}, 500);
			}



			function update_change_password_dialog_tips(message)
			{
				$(".change_password_dialog_tip").text(message).addClass("ui-state-highlight");
				setTimeout(function() {
					$(".change_password_dialog_tip").removeClass("ui-state-highlight", 1500);
				}, 500);
			}



			function do_add_user(login, password, admin)
			{
				var xhr = get_xhr_object();
				if (xhr == null)
					return;
				xhr.onreadystatechange = function() {
					if ((xhr.readyState == 4) && (xhr.status == 200)) {
						load_users();
					}
				};

				var line = "cgi-bin/add-user?name=" + login + "&pwd=" + password + "&type=";
				if (admin)
					line += "1";
				else
					line += "0";
				xhr.open("GET", line, true);
				xhr.send();
			}



			function do_delete_user()
			{
				var selected_user = document.getElementById("users_list").selectedIndex;
				if (selected_user >= 0) {

					var xhr = get_xhr_object();
					if (xhr == null)
						return;
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							load_users();
						}
					};
					xhr.open("GET", "cgi-bin/delete-user?id=" + Users[selected_user].user_id, true);
					xhr.send();
				}
			}



			function number_of_admins()
			{
				var nb_admins = 0;
				for (var idx = 0; idx < Nb_users; idx++)
					if (Users[idx].user_type == 1)
						nb_admins ++;
				return nb_admins;
			}



			function do_change_password(password)
			{
				var xhr = get_xhr_object();
				if (xhr == null)
					return;
				xhr.onreadystatechange = function() {
					if ((xhr.readyState == 4) && (xhr.status == 200)) {
						load_users();
					}
				};
				xhr.open("GET", "cgi-bin/change-password?id=" + Users[document.getElementById("users_list").selectedIndex].user_id + "&pwd=" + password, true);
				xhr.send();
			}



			function load_groups_and_devices_names_arrays()
			{
				var xhr = get_xhr_object();
				if (xhr == null)
					return;
				xhr.onreadystatechange = function()
				{
					if ((xhr.readyState == 4) && (xhr.status == 200)) {
						var response = xhr.responseText;
						var values = response.split("%");
						var i = 0;
						for (i = 0; i < Nb_devices_per_group * Nb_groups; i ++) {
							Devices_names[i] = values[32 + i * 12 + 0];
						}
						for (i = 0; i < Nb_groups; i ++) {
							Groups_names[i] = values[32 + Nb_devices_per_group * Nb_groups * 12 + i];
						}
						display_devices_tables();
					}
				};
				xhr.open("GET", "cgi-bin/get-shm-data", true);
				xhr.send();
			}



			function display_devices_tables()
			{
				var td;

				for (var group = 0; group < Nb_groups; group++) {
					td = document.getElementById("td-grp-" + group);
					td.innerHTML = Groups_names[group];

					for (var dev = 0; dev < Nb_devices_per_group; dev ++) {
						var lbl = document.getElementById("lbl-" + group + "-" + dev);
						lbl.innerHTML = Devices_names[dev + group * Nb_devices_per_group];
					}
				}
			}



			function load_users()
			{
				Users = new Array();
				Nb_users = 0;

				var xhr = get_xhr_object();
				if (xhr != null) {
					xhr.onreadystatechange = function() {
						if ((xhr.readyState == 4) && (xhr.status == 200)) {
							var response = xhr.responseText;
							var users_data = response.split(" ");
							users_data.forEach(function(user_data) {
								if (user_data.length > 8) {

									var user_item = user_data.split(",");
									<?php
										if (! $Factory_mode)
											echo 'if ((user_item[2] & 2) == 0)';
									?>
									Users[Nb_users ++] = new User(user_item[1], user_item[0], user_item[2], user_item[3]);
								}
							})
							refresh_users_list();
						}
					};
					xhr.open("GET", "cgi-bin/get-users", true);
					xhr.send();
				}
			}



			function refresh_users_list()
			{
				var users_list = document.getElementById("users_list");

				clear_all_items_from_list(users_list);
				fill_users_list_and_select_first(users_list);
			}



			function clear_all_items_from_list(list)
			{
				while (list.hasChildNodes())
					list.removeChild(list.childNodes[0]);
			}



			function fill_users_list_and_select_first(list)
			{
				for (var i = 0; i < Nb_users; i++) {
					var opt = document.createElement('option');
					opt.value = i;
					opt.innerHTML = Users[i].user_name;
					list.appendChild(opt);
				}

				if (Nb_users > 0)
					list.selectedIndex = 0;

				users_list_selection_changed_callback();
			}



			function users_list_selection_changed_callback()
			{
				var selected_user = document.getElementById("users_list").selectedIndex;
				if (selected_user >= 0) {

					document.getElementById("user_admin_checkbox").checked = ((Users[selected_user].user_type & 1) != 0);
					document.getElementById("user_admin_checkbox").disabled = false;
					if (document.getElementById("user_factory_checkbox") != null) {
						document.getElementById("user_factory_checkbox").checked = ((Users[selected_user].user_type & 2) != 0);
						document.getElementById("user_factory_checkbox").disabled = false;
					}
					document.getElementById("delete_user_button").disabled = false;
					document.getElementById("change_password_button").disabled = false;
					document.getElementById("save_button").disabled = false;

					for (var group = 0; group < Nb_groups; group++) {
						for (var dev = 0; dev < Nb_devices_per_group; dev ++) {
							var ck = document.getElementById("ck-" + group + "-" + dev);
							ck.checked = (Users[selected_user].user_permissions[group * Nb_devices_per_group + dev] == "1");
							ck.disabled = false;
						}
					}

				} else {

					document.getElementById("user_admin_checkbox").checked = false;
					document.getElementById("user_admin_checkbox").disabled = true;
					if (document.getElementById("user_factory_checkbox") != null) {
						document.getElementById("user_factory_checkbox").checked = false;
						document.getElementById("user_factory_checkbox").disabled = false;
					}
					document.getElementById("delete_user_button").disabled = true;
					document.getElementById("change_password_button").disabled = true;
					document.getElementById("save_button").disabled = true;

					for (var group = 0; group < Nb_groups; group++) {
						for (var dev = 0; dev < Nb_devices_per_group; dev ++) {
							var ck = document.getElementById("ck-" + group + "-" + dev);
							ck.checked = false;
							ck.disabled = true;
						}
					}
				}
			}



			function change_user_admin_callback()
			{
				var selected_user = document.getElementById("users_list").selectedIndex;
				if (selected_user >= 0) {

					if (document.getElementById("user_admin_checkbox").checked) {
						Users[selected_user].user_type |= 1;
					} else {
						if (number_of_admins() == 1) {
							if (localStorage.getItem("HytemLang") == "fr") {
								alert("Vous ne pouvez pas supprimer les derniers privilèges administrateur.");
							} else {
								alert("You can't remove the last administrator priviledge.");
							}
							document.getElementById("user_admin_checkbox").checked = true;
							return;
						}
						Users[selected_user].user_type &= ~1;
					}
				}
			}



			function change_user_factory_callback()
			{
				var selected_user = document.getElementById("users_list").selectedIndex;
				if (selected_user >= 0) {

					if (document.getElementById("user_factory_checkbox") == null)
						return;

					if (document.getElementById("user_factory_checkbox").checked) {
						Users[selected_user].user_type |= 2;
					} else {
						Users[selected_user].user_type &= ~2;
					}
				}
			}



			function change_permission_callback(group, dev)
			{
				var selected_user = document.getElementById("users_list").selectedIndex;
				if (selected_user >= 0) {

					if (document.getElementById("ck-" + group + "-" + dev).checked)
						Users[selected_user].user_permissions[group * Nb_devices_per_group + dev] = "1";
					else
						Users[selected_user].user_permissions[group * Nb_devices_per_group + dev] = "0";
				}
			}



			function all_devices_button_callback(group)
			{
				var selected_user = document.getElementById("users_list").selectedIndex;
				if (selected_user >= 0) {

					for (var dev = 0; dev < Nb_devices_per_group; dev++) {
						document.getElementById("ck-" + group + "-" + dev).checked = true;
						Users[selected_user].user_permissions[group * Nb_devices_per_group + dev] = "1";
					}
				}
			}



			function none_devices_button_callback(group)
			{
				var selected_user = document.getElementById("users_list").selectedIndex;
				if (selected_user >= 0) {

					for (var dev = 0; dev < Nb_devices_per_group; dev++) {
						document.getElementById("ck-" + group + "-" + dev).checked = false;
						Users[selected_user].user_permissions[group * Nb_devices_per_group + dev] = "0";
					}
				}
			}



			function save_callback()
			{
				for (user = 0; user < Nb_users; user ++) {

					var xhr;

					xhr = get_xhr_object();
					if (xhr != null) {
						xhr.open("GET", "cgi-bin/set-user-type?id=" + Users[user].user_id + "&type=" + Users[user].user_type, true);
						xhr.send();
					}

					xhr = get_xhr_object();
					if (xhr != null) {
						var permissions = "";
						for (var group = 0; group < Nb_groups; group++) {
							for (var dev = 0; dev < Nb_devices_per_group; dev ++) {
								permissions = permissions + Users[user].user_permissions[group * Nb_devices_per_group + dev];
							}
						}
						xhr.open("GET", "cgi-bin/set-user-permissions?id=" + Users[user].user_id + "&perm=" + permissions, true);
						xhr.send();
					}
				}
			}

		</script>
	</body>
</html>
