<?php
	/*
		Group names, device names and types configuration.

		Design and implementation by Logilin (www.logilin.fr).
	*/

	require('hytem-header.php');

	if ((! $Factory_mode) && (! $Admin_logged)) {
		header("Location: /index.php");
	}
?>
<!DOCTYPE html>
<html>
	<head>
		<?php  fill_html_head_block(); ?>
	</head>

	<body onselectstart="return false;" oncontextmenu="return false;"  style='overflow-y: scroll; overflow-x: auto; width: 99%;' >

		<?php fill_html_header_block("Setup"); ?>
		<?php fill_tabs_block("setup", ""); ?>

		<div class="content">

			<?php
				unset($output);
				exec("/home/www/cgi-bin/get-number-of-groups", $output, $retval);
				$Nb_groups = (int)($output[2]);

				unset($output);
				exec("/home/www/cgi-bin/get-devices-per-group", $output, $retval);
				$Nb_devices_per_group = (int)($output[2]);
			?>

			<br />

			<table id="global-table">
				<tr style="vertical-align: top">
					<td>
						<table id="system-name-table">
							<tr>
								<td id="system-name-td">
									System name:
								</td>
								<td>
									<input type="text" id='system-name-text' maxlength='32' onkeypress='field_modified();' onchange='field_modified();'>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td></td></tr>
				<tr style="vertical-align: top">
					<td id="groups-menu" style="vertical-align: top">
						<table id="groups-table">
							<?php
								if ($Nb_groups <= 4) {
									for ($i=0; $i < $Nb_groups; $i ++){
										echo "<tr>";
										echo "<td class='group_name' id='group-name-$i'>".($i+1)."</td>";
										echo "</tr>";
										echo "<tr><td class='group_name_separator'></td></tr>";
									}
								} else if ($Nb_groups <= 16) {
									$n = floor(($Nb_groups + 1) / 2);
									for ($i=0; $i < $n; $i ++){
										echo "<tr>";
										echo "<td class='group_name' id='group-name-$i'>".($i+1)."</td>";
										if (($i + $n) < $Nb_groups) {
											echo "<td class='group_name' id='group-name-".($i+$n)."'>".($i+$n+1)."</td>";
										}
										echo "</tr>";
										echo "<tr><td class='group_name_separator'></td></tr>";
									}
								} else {
								$n = floor(($Nb_groups + 3) / 4);
								for ($i=0; $i < $n; $i ++){
									echo "<tr>";
									echo "<td class='group_name' id='group-name-$i'>".($i+1)."</td>";
									if (($i + $n) < $Nb_groups) {
										echo "<td class='group_name' id='group-name-".($i+$n)."'>".($i+$n+1)."</td>";
									}
									if (($i + 2 * $n) < $Nb_groups) {
										echo "<td class='group_name' id='group-name-".($i+ 2 * $n)."'>".($i + 2 * $n + 1)."</td>";
									}
									if (($i + 3 * $n) < $Nb_groups) {
										echo "<td class='group_name' id='group-name-".($i+ 3 * $n)."'>".($i + 3 * $n + 1)."</td>";
									}
									echo "</tr>";
									echo "<tr><td class='group_name_separator'></td></tr>";
								}
							}
							?>
						</table>
					</td>
					<td style="vertical-align: top">
						<table id="dev-names-table">
<!--							<tr>
								<td class='dev-name-separator' colspan="5">
									&nbsp;
								</td>
							</tr>
-->							<tr id="group-name-block">
								<td class="dev-num" id='group-name-label'>
									Group name:&nbsp;
								</td><td>
									<input type="text" class="setup-dev-name" id='group-name' maxlength='4' onkeypress='field_modified();' onchange='field_modified();' >
								</td>
								<td colspan="3">
								</td>
							</tr><tr>
								<td class='dev-name-separator' colspan="2">
									&nbsp;
								</td>
								<?php
									if ($Factory_mode) {
										if (($Supported_devices == 1)
										 || ($Supported_devices == 2)
										 || ($Supported_devices == 4)) {
											echo "<td colspan='3'>&nbsp;</td>";
										} else {
											if ($Supported_devices & 1)
												echo "<td>Attenuator</td>";
											if ($Supported_devices & 2)
												echo "<td>Switch</td>";
											if ($Supported_devices & 4)
												echo "<td>SPST</td>";
											if ($Supported_devices != 7)
												echo "<td>&nbsp;</td>";
										}
									}
								?>
								<td>Lock IP</td>
							</tr>
							<?php
								for ($i = 0; $i < $Nb_devices_per_group; $i ++) {
									echo "<tr>";
									echo "  <td class='dev-num' id='dev-num-$i'>";
									echo "    Dev. ".($i+1).":&nbsp;";
									echo "  </td>";
									echo "  <td>";
									echo "    <input class='setup-dev-name' type='text' id='dev-name-$i' maxlength='6' onkeypress='field_modified();' onchange='field_modified();' >";
									echo "  </td>";
									if ($Factory_mode) {
										if (($Supported_devices == 1)
										 || ($Supported_devices == 2)
										 || ($Supported_devices == 4)) {
											echo "<td colspan='3'>&nbsp;</td>";
										} else {
											if ($Supported_devices & 1) {
												echo "  <td style='text-align: center;'>";
												echo "    <input type='radio' name='dev-type-$i' value='1' id='bt-attenuator-$i' onclick='field_modified();' />";
												echo "  </td>";
											}
											if ($Supported_devices & 2) {
												echo "  <td style='text-align: center;'>";
												echo "    <input type='radio' name='dev-type-$i' value='2' id='bt-switch-$i' onclick='field_modified();' />";
												echo "  </td>";
											}
											if ($Supported_devices & 4) {
												echo "  <td style='text-align: center;'>";
												echo "    <input type='radio' name='dev-type-$i' value='2' id='bt-spst-$i' onclick='field_modified();' />";
												echo "  </td>";
											}
											if ($Supported_devices != 7)
												echo "<td>&nbsp;</td>";
										}
									}
									echo "  <td class='dev-num' id='lock-ip-$i'></td>";
									echo "</tr>";
								}
							?>
						</table>
						<br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<table id="https-option-table">
							<tr>
								<td>
									<input type="checkbox" name="use-https-system-check" id="use-https-system-check" onclick='field_modified();'>
									<label for="use-https-system-check" id='use-https-system-label'>Use HTTPS protocol instead of HTTP for web HMI (effective after system reboot).</label>
								</td>
							</tr>
						</table>
						<br/>
						<table id="ok-cancel-table">
							<tr>
								<td><input type="button" value="Ok" id='ok-button' onclick="ok_button_cb();" disabled ></td>
								<td><input type="button" value="Cancel" id='cancel-button' onclick="load_from_server();" disabled ></td>
							</tr>
						</table>
						<br />
						<table id="reboot-table">
							<tr>
								<td><input type="button" value="Reboot" id='reboot-button' onclick="reboot_button_cb();" ></td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</div>

		<script type="text/javascript">

			var Nb_groups = <?php echo $Nb_groups; ?>;
			var Nb_devices_per_group = <?php echo $Nb_devices_per_group; ?>;
			var Current_group;
			var System_name;

			var Devices_names = [];
			var Devices_types = [];
			var Devices_lock_ip = [];
			var Groups_names = [];

			var Lock_ip_interval = 0;


			window.onload = function()
			{
				update_header_from_lang();

				Current_group = 0;

				// Install a common keypress handler
				var i;

				for (i = 0; i < Nb_devices_per_group; i++) {
					document.getElementById("dev-name-"+i).addEventListener("keydown", key_pressed_cb, false);
				}

				if (Nb_groups > 1) {
					for (i = 0; i < Nb_groups; i ++) {
						var btn = document.getElementById('group-name-' + i);
						btn.number = i;
						if (btn.number == Current_group)
							btn.className = "group_name_selected";
						else
							btn.className = "group_name";
						btn.addEventListener('click', change_group_callback);
					}
					for (i = 0; i < Nb_groups; i++) {
						document.getElementById("group-name-"+i).addEventListener("keydown", key_pressed_cb, false);
					}
					document.getElementById("group-name").addEventListener("keydown", key_pressed_cb, false);
				} else {
					document.getElementById('group-name-block').style.display = 'none';
					document.getElementById('groups-menu').style.display = 'none';
				}

				if (localStorage.getItem("HytemLang") == "fr") {
					document.getElementById('system-name-td').innerHTML = "Nom du système&nbsp;:"
					document.getElementById('group-name-label').innerHTML = "Nom groupe&nbsp;:";
					document.getElementById('use-https-system-label').innerHTML = "Utiliser le protocole HTTPS au lieu de HTTP pour l'interface web (nécessite un redémarrage).";
					document.getElementById('reboot-button').value = "Redémarrer";
					document.getElementById('cancel-button').value = "Annuler";
				}

				load_from_server();

				load_use_https();

			}



			window.onbeforeunload = function()
			{
				return 'Are you sure you want to quit?';
			}



			function key_pressed_cb(evt)
			{
				if (evt.keyCode === 13) { // Enter key
					ok_button_cb();
					return false; // handled.
				}
				if (evt.keyCode == 27) { // Escape key
					load_from_server();
					return false; // handled.
				}
				return true; // propagate.
			}



			function change_group_callback(evt)
			{
				if (evt != null)
					evt.preventDefault();

				store_group_configuration();

				if ((evt == null) || (evt.target.number == Current_group))
					return false;

				document.getElementById("group-name-" + Current_group).className = "group_name";
				evt.target.className = "group_name_selected";
				Current_group = evt.target.number;

				update_fields_contents();

				return false;
			};



			function store_group_configuration()
			{

				for (var i = 0; i < Nb_devices_per_group; i ++) {
					var dev = i + Nb_devices_per_group * Current_group;
					Devices_names[dev] = document.getElementById("dev-name-" + i).value.toUpperCase();
					<?php
						if (! $Factory_mode) {
							echo "continue;";
						} else {

							echo "Devices_types[dev] = 0;";

							if ($Supported_devices == 1) {
								echo "Devices_types[dev] = 1;";
							} else {
								if ($Supported_devices & 1) {
									echo "if (document.getElementById('bt-attenuator-' + i).checked)  Devices_types[dev] = 1;";
								}
							}

							if ($Supported_devices == 2) {
								echo "Devices_types[dev] = 2;";
							} else {
								if ($Supported_devices & 2) {
									echo "if (document.getElementById('bt-switch-' + i).checked)  Devices_types[dev] = 2;";
								}
							}

							if ($Supported_devices == 4) {
								echo "Devices_types[dev] = 4;";
							} else {
								if ($Supported_devices & 4) {
									echo "if (document.getElementById('bt-spst-' + i).checked)  Devices_types[dev] = 4;";
								}
							}
						}
					?>
				}
				Groups_names[Current_group] = document.getElementById("group-name").value.toUpperCase();
			}



			function load_from_server()
			{
				var xhr = get_xhr_object();

				if (xhr == null)
					return;

				xhr.onreadystatechange = function()
				{
					if ((xhr.readyState == 4) && (xhr.status == 200)) {

						var response = xhr.responseText;
						var values = response.split("%");

						for (var i = 0; i < Nb_devices_per_group; i ++) {
							document.getElementById("dev-num-" + i).innerHTML = "Dev. " + (i + 1) + ":&nbsp";
						}
						for (var i = 0; i < Nb_devices_per_group * Nb_groups; i ++) {
							Devices_names[i] = values[32 + i * 12 + 0];
							Devices_types[i] = values[32 + i * 12 + 1];
						}
						for (var i = 0; i < Nb_groups; i ++) {
							Groups_names[i] = values[32 + Nb_devices_per_group * Nb_groups * 12 + i];
						}
						update_fields_contents();

						System_name = values[15];
						document.getElementById('system-name-text').value = System_name;

						window.onbeforeunload=function(e){};
						document.getElementById('ok-button').disabled = true;
						document.getElementById('cancel-button').disabled = true;

						if (Lock_ip_interval != 0) {
							clearInterval(Lock_ip_interval);
						}
						update_lock_ip();

					}
				};
				xhr.open("GET", "cgi-bin/get-shm-data", true);
				xhr.send();
			}



			function update_fields_contents()
			{

				for (var i = 0; i < Nb_groups; i ++) {
					document.getElementById("group-name-" + i).innerHTML = Groups_names[i];
				}
				document.getElementById("group-name").value = Groups_names[Current_group];

				for (var i = 0; i < Nb_devices_per_group; i ++) {
					var dev = i + Nb_devices_per_group * Current_group;
					document.getElementById("dev-name-" + i).value =  Devices_names[dev];
				}

				<?php
					if (! $Factory_mode)
						echo "return;";
				?>

				for (var i = 0; i < Nb_devices_per_group; i ++) {
					var dev = i + Nb_devices_per_group * Current_group;
					<?php
						if (($Supported_devices != 1) && ($Supported_devices & 1))
							echo "document.getElementById('bt-attenuator-' + i).checked = (Devices_types[dev] == 1);";
						if (($Supported_devices != 2) && ($Supported_devices & 2))
							echo "document.getElementById('bt-switch-' + i).checked = (Devices_types[dev] == 2);";
						if (($Supported_devices != 4) && ($Supported_devices & 4))
							echo "document.getElementById('bt-spst-' + i).checked = (Devices_types[dev] == 4);";
					?>
				}

			}


			function update_lock_ip()
			{
				var xhr = get_xhr_object();

				if (xhr == null)
					return;

				xhr.onreadystatechange = function()
				{
					if ((xhr.readyState == 4) && (xhr.status == 200)) {

						var response = xhr.responseText;
						var values = response.split("%");

						for (var i = 0; i < Nb_devices_per_group * Nb_groups; i ++) {
							Devices_lock_ip[i] = "";
							if ((values[32 + i * 12 + 8] != 0) || (values[32 + i * 12 + 9] != 0) || (values[32 + i * 12 + 10] != 0) || (values[32 + i * 12 + 11] != 0)) {
								Devices_lock_ip[i] = Devices_lock_ip[i] + values[32 + i * 12 + 8] + ".";
								Devices_lock_ip[i] = Devices_lock_ip[i] + values[32 + i * 12 + 9] + ".";
								Devices_lock_ip[i] = Devices_lock_ip[i] + values[32 + i * 12 + 10] + ".";
								Devices_lock_ip[i] = Devices_lock_ip[i] + values[32 + i * 12 + 11];
							}
						}
						for (var i = 0; i < Nb_devices_per_group; i ++) {
							var dev = i + Nb_devices_per_group * Current_group;
							document.getElementById("lock-ip-" + i).innerHTML = Devices_lock_ip[dev];
						}
					}
				};
				xhr.open("GET", "cgi-bin/get-shm-data", true);
				xhr.send();

				if (Lock_ip_interval == 0) {
					Lock_ip_interval = setInterval(update_lock_ip, 500);
				}
			}


			function ok_button_cb()
			{

				var line = "";
				var i;

				store_group_configuration();

				for (i = 0; i < Nb_devices_per_group * Nb_groups; i ++) {

					if (Devices_names[i] == '')
						Devices_names[i] = (i + 1);

					line = line + Devices_names[i] + "," + Devices_types[i] + ",";
				}

				for (i = 0; i < Nb_groups; i ++) {

					if (Groups_names[i] == '')
						Groups_names[i] = (i + 1);

					line = line + Groups_names[i] + ",";
				}

				var xhr = get_xhr_object();
				if (xhr == null)
					return;

				xhr.onreadystatechange = function() {
					if ((xhr.readyState == 4) && (xhr.status == 200)) {
						setTimeout(load_from_server, 500);
					}
				};
				xhr.open("GET", "action/set-groups-and-devices.php?line=" + line, true);
				xhr.send();

				save_use_https();
			}



			function field_modified ()
			{
				document.getElementById('ok-button').disabled = false;
				document.getElementById('cancel-button').disabled = false;
				window.onbeforeunload = function (e) {
					return "Your modifications will be lost";
				};
			}



			function save_use_https()
			{
				var xhr;
				var line;

				xhr = get_xhr_object();
				if (xhr != null) {
					if (document.getElementById('use-https-system-check').checked) {
						line='action/set-option.php?https=1';
					} else {
						line='action/set-option.php?https=0';
					}
					xhr.open("GET", line, true);
					xhr.send();

					save_system_name();
				}
			}



			function save_system_name()
			{
				var xhr;
				var line;
				var name;

				name = document.getElementById('system-name-text').value;
				if (System_name != name) {
					xhr = get_xhr_object();
					if (xhr != null) {
						line = 'action/set-system-name.php?name=' + name;
						xhr.open("GET", line, true);
						xhr.send();
						window.onbeforeunload=function(e){};
						setTimeout(reload_page, 250);
					}
				}
			}

			function reload_page()
			{
				window.location.href = window.location.href;
			}


			function load_use_https()
			{
				var xhr = get_xhr_object();

				if (xhr == null)
					return;

				xhr.onreadystatechange = function()
				{
					if ((xhr.readyState == 4) && (xhr.status == 200)) {
						var response = xhr.responseText;
						var values = response.split("%");
						document.getElementById('use-https-system-check').checked = (values[13] != 0);
					}
				};

				xhr.open("GET", "cgi-bin/get-shm-data", true);
				xhr.send();
			}



			function reboot_button_cb()
			{
				var confirmation;

				if (localStorage.getItem("HytemLang") == "fr")
					confirmation = confirm("Êtes vous sûr de vouloir redémarrer le système ?");
				else
					confirmation = confirm("Are you sure you want to reboot the system?");

				if (confirmation)
					window.location.href = "reboot.php";
			}

		</script>
	</body>
</html>
