<?php
	/*
		Sequence player.

		Design and implementation by Logilin (www.logilin.fr) for Hytem (www.hytem.net)
	*/
	require('hytem-header.php');

	if (! $Logged_in) {
		header("Location: /index.php");
	}
?>
<!DOCTYPE html>
<html>
	<head>
		<?php  fill_html_head_block(); ?>
		<script type="text/javascript" language="Javascript" src="js/device-player.js"></script>
	</head>

	<body onselectstart='return false;' oncontextmenu='return false;' style='overflow-y: scroll; overflow-x: auto; width: 99%;' >

		<?php fill_html_header_block("Sequence Player"); ?>
		<?php fill_tabs_block("player", ""); ?>

		<div class="content">
			<br />
			<?php
				unset($output);
				exec("/home/www/cgi-bin/get-number-of-groups", $output, $retval);
				$nb_groups = (int)($output[2]);

				unset($output);
				exec("/home/www/cgi-bin/get-devices-per-group", $output, $retval);
				$nb_players = (int)($output[2]);

				$directory = "/data/sequences/";
				$seq_files_array = array_diff(scandir($directory), array('..', '.'));
			?>
			<table id='global-table'>
				<tr>
					<td id="groups-menu" style='vertical-align: top'>
						<table id="groups-table">
						<?php
							if ($nb_groups <= 4) {
								for ($i=0; $i < $nb_groups; $i ++){
									echo "<tr>";
									echo "<td class='group_name' id='group-name-$i'>".($i+1)."</td>";
									echo "</tr>";
									echo "<tr><td class='group_name_separator'></td></tr>";
								}
							} else if ($nb_groups <= 16) {
								$n = floor(($nb_groups + 1) / 2);
								for ($i=0; $i < $n; $i ++){
									echo "<tr>";
									echo "<td class='group_name' id='group-name-$i'>".($i+1)."</td>";
									if (($i + $n) < $nb_groups) {
										echo "<td class='group_name' id='group-name-".($i+$n)."'>".($i+$n+1)."</td>";
									}
									echo "</tr>";
									echo "<tr><td class='group_name_separator'></td></tr>";
								}
							} else {
								$n = floor(($nb_groups + 3) / 4);
								for ($i=0; $i < $n; $i ++){
									echo "<tr>";
									echo "<td class='group_name' id='group-name-$i'>".($i+1)."</td>";
									if (($i + $n) < $nb_groups) {
										echo "<td class='group_name' id='group-name-".($i+$n)."'>".($i+$n+1)."</td>";
									}
									if (($i + 2 * $n) < $nb_groups) {
										echo "<td class='group_name' id='group-name-".($i+ 2 * $n)."'>".($i + 2 * $n + 1)."</td>";
									}
									if (($i + 3 * $n) < $nb_groups) {
										echo "<td class='group_name' id='group-name-".($i+ 3 * $n)."'>".($i + 3 * $n + 1)."</td>";
									}
									echo "</tr>";
									echo "<tr><td class='group_name_separator'></td></tr>";
								}
							}
						?>
						</table>
					</td>
					<td>
						<table class='players-table'>
						<?php
							for ($i = 0; $i < $nb_players; $i ++) {
								if ($i == 0) {
									echo "<tr class='player-title-tr'>";
										echo "<td class='player-title-td'>#</td>";
										echo "<td class='player-title-td' id='name-column'>Name</td>";
										echo "<td class='player-title-td' id='synchro-type-column'>Synchro<br/>type</td>";
										echo "<td class='player-title-td' id='master-ip-column'>Master<br/>IP</td>";
										echo "<td class='player-title-td' id='master-group-column'>Master<br/>group</td>";
										echo "<td class='player-title-td' id='master-channel-column'>Master<br/>channel</td>";
										echo "<td class='player-title-td' id='sequence-file-column'>Sequence<br/>file</td>";
										echo "<td class='player-title-td'>&nbsp;</td></tr>\n";
								}
								echo "<tr class='player-tr'>";
									// Name of the device.
									echo "<td class='player-td'><span class='player-dev-num'>".($i+1)."</span></td>";
									echo "<td class='player-td'><span class='player-dev-name' id='player-dev-name-$i'></span></td>";
									// List of synchronizations available.
									echo "<td class='player-td'><select id='synchro-mode-$i' class='player-synchros' onchange='synchros_selection_changed_cb($i);' >";
										echo "<option value='0' id='master-option-".($i+1)."'> Master </option>";
										echo "<option value='1' id='slave-option-".($i+1)."'> Slave </option>";
									echo "</select>&nbsp;&nbsp;</td>";
									// List of Master host
									echo "<td class='player-td'><select id='master-host-$i' class='player-synchros' onchange='hosts_selection_changed_cb($i);' style='width: 5em;' >";
										echo "<option value='-1'> Local </option>";
									echo "</select>&nbsp;&nbsp;</td>";
									// List of groups.
									echo "<td class='player-td'";
/*									if ($nb_groups == 1) // Hide the TD.
										echo " style='display: none;' ";
*/									echo "><select id='master-group-$i' class='player-synchros' DISABLED='disabled' onchange='groups_selection_changed_cb($i);' style='width: 3em;'>";
									echo "</select>&nbsp;&nbsp;</td>";
									// List of channels.
									echo "<td class='player-td'><select id='master-channel-$i' class='player-synchros' DISABLED='disabled' onchange='channels_selection_changed_cb($i);' style='width: 5em;'>";
									echo "</select>&nbsp;&nbsp;</td>";
									// List of sequences.
									echo "<td class='player-td'><select id='sequence-$i' class='player-sequences' onchange='sequences_selection_changed_cb($i);'>";
										echo "<option value='None' id='sequence-none-".($i+1)."' selected> None </option>";
									echo "</select>&nbsp;&nbsp;&nbsp;</td>";
									// The player buttons.
									echo "<td class='player-td'><span class='player-buttons' id='player-buttons-$i'>";
										echo "<img class='player-button' src='png/bt-play-32.png'  height=32 width=32 alt='Start' id='start-button-img-${i}' onclick='start_player(${i});' />";
										echo "<img class='player-button' src='png/bt-pause-32.png' height=32 width=32 alt='Pause' id='pause-button-img-${i}' onclick='pause_player(${i});' />";
										echo "<img class='player-button' src='png/bt-stop-32.png'  height=32 width=32 alt='Stop'  id='stop-button-img-${i}'  onclick='stop_player(${i});' />";
									echo "</span></td>";
								echo "</tr>\n";
							} // for
						?>
						</table>
					</td>
				</tr>
			</table>
		</div>

		<script type="text/javascript">

			// An array of window.nb_groups * window.nb_players integers.
			// user_permissions[n] = 1 if the current user is allowed to access device "n",
			// 0 otherwise.
			var User_permissions = null;

			/// \brief Method called once at loading.
			///
			window.onload = function()
			{

				update_header_from_lang();

				// Fill the global variables concerning groups and players.
				window.nb_groups   = <?php echo $nb_groups;?>;
				window.nb_players  = <?php echo $nb_players;?>,
				window.current_group = 0;
				window.dev_names = [];
				window.dev_types = [];
				window.grp_names = [];
				window.synchro_mode    = [];
				window.synchro_action  = [];
				window.synchro_master  = [];
				window.synchro_channel = [];
				window.synchro_file    = [];

				// Display (or hide) the group buttons panel.
				if (window.nb_groups > 1) {
					for (var i = 0; i < window.nb_groups; i ++) {
						var btn = document.getElementById('group-name-' + i);
						btn.number = i;
						if (btn.number == window.current_group)
							btn.className = "group_name_selected"
						else
							btn.className = "group_name"
						btn.addEventListener('click', group_name_cb);
					}
				} else {
					// If there's only one group, hide the buttons panel.
					document.getElementById("groups-menu").style.display = 'none';
				}
				load_user_permissions_and_display_players();

				if (localStorage.getItem("HytemLang") == "fr") {
					document.getElementById('name-column').innerHTML = 'Nom';
					document.getElementById('synchro-type-column').innerHTML = 'Type<br/>synchro';
					document.getElementById('master-ip-column').innerHTML = 'Num.<br/>maître';
					document.getElementById('master-group-column').innerHTML = 'Groupe<br/>maître';
					document.getElementById('master-channel-column').innerHTML = 'Canal<br/>maître';
					document.getElementById('sequence-file-column').innerHTML = 'Séquence';
					for (var i = 1; i <= window.nb_players; i++){
						document.getElementById('master-option-' + i).innerHTML = 'Maître';
						document.getElementById('slave-option-' + i).innerHTML = 'Esclave';
						document.getElementById('sequence-none-' + i).innerHTML = 'Aucune';
					}
				} else {
					document.getElementById('name-column').innerHTML = 'Name';
					document.getElementById('synchro-type-column').innerHTML = 'Sync<br/>type';
					document.getElementById('master-ip-column').innerHTML = 'Master<br/>Num';
					document.getElementById('master-group-column').innerHTML = 'Master<br/>Group';
					document.getElementById('master-channel-column').innerHTML = 'Master<br/>channel';
					document.getElementById('sequence-file-column').innerHTML = 'Sequence';
					for (var i = 1; i <= window.nb_players; i++){
						document.getElementById('master-option-' + i).innerHTML = 'Master';
						document.getElementById('slave-option-' + i).innerHTML = 'Slave';
						document.getElementById('sequence-none-' + i).innerHTML = 'None';
					}

				}
			}



			/// \brief  Load the user permissions array if the multiusers
			///         option is enabled, then display all players.
			///
			function load_user_permissions_and_display_players()
			{
				User_permissions = new Array;

				if (<?php print $Multiusers ?> == 0) {

					for (var i = 0; i < window.nb_groups * window.nb_players; i++)
						User_permissions[i] = 1;

				} else {

					if (<?php print $Logged_in ?> == 0) {

						for (var i = 0; i < window.nb_groups * window.nb_players; i++)
							User_permissions[i] = 0;

					} else {

						var xhr = get_xhr_object();
						if (xhr != null) {
							xhr.onreadystatechange = function() {
								if ((xhr.readyState == 4) && (xhr.status == 200)) {
									var response = xhr.responseText;
									for (var i = 0; i < response.length; i ++) {
										User_permissions[i] = (response.charAt(i) == 0) ? 0 : 1;
									}
									for (var i = response.length; i < window.nb_groups * window.nb_players; i ++)
										User_permissions[i] = 0;
									load_and_display_all_names_and_types();
								}
							};
							xhr.open("GET", "cgi-bin/get-permissions?id=<?php print $_SESSION['LOGIN'] ?>", true);
							xhr.send();
						}
					}
				}
			}



			/// \brief Callback for click on a group button.
			///
			/// \param evt - The button clicked.
			///
			/// \returns Always 'false'.
			///
			function group_name_cb(evt)
			{
				evt.preventDefault();
				if (evt.target.number == window.current_group)
					return false;
				document.getElementById("group-name-" + window.current_group).className = "group_name";
				evt.target.className = "group_name_selected";
				window.current_group = evt.target.number;
				update_player_names_and_sequences();
				display_all_players();
				return false;
			}

		</script>
	</body>
</html>
