<?php
	/*
		Sequence manager for the attenuator control system.

		Design and implementation by Logilin (www.logilin.fr) for Hytem (www.hytem.net)
	*/
	require('hytem-header.php');
	if (! $Logged_in) {
		header("Location: /index.php");
	}
?>
<!DOCTYPE html>
<html>
	<head>
		<?php  fill_html_head_block(); ?>
		<script type="text/javascript" language="Javascript" src="js/sequence_manager.js"></script>
	</head>

	<?php
		if ((isset($_POST["submit"]))
		 && (isset($_FILES["uploaded_file"]["name"]))
		 && (isset($_FILES["uploaded_file"]["tmp_name"]))) {
			$target_dir = "/data/sequences"; // No final slash!
			$target_file = $target_dir . "/" . basename($_FILES["uploaded_file"]["name"]);
			$target_file = str_replace(' ', '_', $target_file);
			$target_file = preg_replace('/[^A-Za-z0-9\-._\/]/', '', $target_file);
			$imageFileType = pathinfo($target_file,PATHINFO_EXTENSION);
			move_uploaded_file($_FILES["uploaded_file"]["tmp_name"], $target_file);
			unset($_FILES["uploaded_file"]);
			unset($_POST["submit"]);
		}
	?>

	<body onselectstart='return false;' oncontextmenu='return false;' style='overflow-y: scroll; overflow-x: auto; width: 99%;' >

		<?php fill_html_header_block("Sequence Manager"); ?>

		<?php fill_tabs_block("manager", ""); ?>

		<div class="content">
			<br/><br/>
			<table id="sequence_manager_table">
				<tr>
					<td class="sequence_manager_action">
						<select SIZE=10 id="sequence_select">
							<?php
								$directory = "/data/sequences";
								$seq_files = array_diff(scandir($directory), array('..', '.'));
								foreach ($seq_files as $key => $value){
									echo "<option value='$value'>$value</option>";
								}
							?>
						</select>
					</td><td>
						<table>
							<tr>
								<td class="sequence_manager_action">
									<form action="manager.php" method="post" enctype="multipart/form-data" id="upload_form">
										<input class="upload_form_button" type="file" name="uploaded_file" id="uploaded_file"/>
										<input class="upload_form_button" type="submit" value="Upload" name="submit">
									</form>
								</td>
							</tr><tr>
								<td class="sequence_manager_action">
									<button class="manager_button" type="button" id='rename-button' onclick="rename_button_cb();">Rename</button>
									&nbsp;&nbsp;&nbsp;
									<button class="manager_button" type="button" id='erase-button' onclick="erase_button_cb();">Erase</button>
									&nbsp;&nbsp;&nbsp;
									<button class="manager_button" type="button" id='download-button' onclick="download_button_cb();">Download to the PC</button>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</div>
		<script type="text/javascript">
			window.onload = function()
			{
				update_header_from_lang();

				if (localStorage.getItem("HytemLang") == "fr") {
					document.getElementById('rename-button').innerHTML = "Renommer";
					document.getElementById('erase-button').innerHTML = "Effacer";
					document.getElementById('download-button').innerHTML = "Télécharger sur le PC";
				}
			}

		</script>
	</body>
</html>
