<?php

	require('hytem-header.php');

	unset($output);
	exec("server-request 4000 GET-MULTIUSERS-OPTION", $output, $retval);
	if ((int)($output[0]) == 0) {
		header("Location: /index.php");
	}

	function verify_login_password($a, $b)
	{
		unset($output);
		exec('server-request 4000 "CONNECT-USER '. $a . ' ' . $b .'"', $output);
		if (strncmp($output[0], "Error", 5) == 0)
			return -1;
		return (int)($output[0]);
	}

	function verify_admin_login($login)
	{
		unset($output);
		exec('server-request 4000 "GET-USER-ID ' . $login .'"', $output, $retval);
		if (strncmp($output[0], "Error", 5) == 0)
			return false;
		$user_id = (int)($output[0]);

		unset($output);
		exec('server-request 4000 "GET-USER-TYPE ' . $user_id . '"', $output, $retval);
		return (((int)($output[0]) & 1) != 0);
	}

	function verify_factory_login($login)
	{
		unset($output);
		exec('server-request 4000 "GET-USER-ID ' . $login .'"', $output, $retval);
		if (strncmp($output[0], "Error", 5) == 0)
			return false;
		$user_id = (int)($output[0]);

		unset($output);
		exec('server-request 4000 "GET-USER-TYPE ' . $user_id . '"', $output, $retval);
		return (((int)($output[0]) & 2) != 0);
	}

	session_start();

	if ((! isset($_SESSION['PREVIOUS_PAGE'])) || (empty($_SESSION['PREVIOUS_PAGE']))) {
		if (isset($_SERVER['HTTP_REFERER']))
			$_SESSION['PREVIOUS_PAGE'] = $_SERVER['HTTP_REFERER'];
		else
			$_SESSION['PREVIOUS_PAGE'] = "/";
	}
	$_SESSION['PREVIOUS_PAGE'] = str_replace("/login.php","/", $_SESSION['PREVIOUS_PAGE']);

	if (isset($_POST['cancel-button'])) {
		$tmp = $_SESSION['PREVIOUS_PAGE'];
		unset ($_SESSION['PREVIOUS_PAGE']);
		$_POST['login-input'] = null;
		$_POST['password-input'] = null;
		header("Location: ".$tmp);
		exit();
	}

	if ((isset($_POST['login-input']))
	 && (!empty($_POST['login-input']))
	 && (isset($_POST['password-input']))
	 && (!empty($_POST['password-input']))) {

		$_SESSION['LOGIN'] = null;
		unset($_SESSION['LOGIN']);

		$user_id = verify_login_password($_POST['login-input'], $_POST['password-input']);
		if ($user_id >= 0)  {

			$_SESSION['LOGIN'] = $user_id;
			$_SESSION['USERNAME'] = $_POST['login-input'];

			if (verify_admin_login($_POST['login-input']))
				$_SESSION['ADMIN'] = true;
			else
				unset($_SESSION['ADMIN']);

			if (verify_factory_login($_POST['login-input']))
				$_SESSION['FACTORY'] = true;
			else
				unset($_SESSION['FACTORY']);

			$_POST['login-input'] = null;
			$_POST['password-input'] = null;

			$tmp = $_SESSION['PREVIOUS_PAGE'];
			unset($_SESSION['PREVIOUS_PAGE']);
			header("Location: ".$tmp);
			exit();
		}
		$error_message = 'Wrong login or password.';
	}

	unset($output);
	exec("server-request 4000 GET-SUPPORTED-DEVICES", $output, $retval);
	$Supported_devices = (int)($output[0]);
	if ($Supported_devices == 1)
		$Devices_name = "Attenuators";
	elseif ($Supported_devices == 2)
		$Devices_name = "Switches";
	elseif ($Supported_devices == 4)
		$Devices_name = "SPST";
	else
		$Devices_name = "Devices";

?>
<!DOCTYPE html>
<html>
	<head>
			<title>Hytem <?php echo $Devices_name; ?> Control</title>

		<meta charset="UTF-8" />
		<meta name="author" content="Logilin - https://www.logilin.fr">

		<link rel="shortcut icon" type="image/png" href="favicon.png" />
		<link rel="stylesheet" href="devices-control.css?version=" />

		<style>
			.login-box {
				box-shadow:       2px 2px 4px #202020;
				border-radius:    5px;
				padding:          5px;
				background-color: #adafac;
				color:            black;
				width:            30em;
				margin:           auto;
				text-align:       center;
			}

			.login-input {
				border-width:     3px;
				border-radius:    5px;
				margin:           4px;
				border-style:     inset;
			}

			.login-button {
				border-width:     3px;
				box-shadow:       2px 2px 4px #202020;
				border-radius:    5px;
				margin:           4px;
				border-style:     outset;
			}
		</style>


	</head>

	<body onselectstart="return false;" oncontextmenu="return false;" >
		<?php fill_html_header_block(""); ?>
		<?php fill_tabs_block("login", ""); ?>

		<form id="login-box" action="login.php" method="post" class="login-box">
			<span id='login-label'></span>
			<input type="text" class="login-input" name="login-input" value="<?php if (isset($_POST['login'])) echo htmlentities(trim($_POST['login'])); ?>">
			<br/>
			<span id='password-label'></span>
			<input type="password" class="login-input" name="password-input" value="<?php if (isset($_POST['password'])) echo htmlentities(trim($_POST['password'])); ?>">
			<br/>
			<input type="submit" class="login-button" id="login-button" name="login-button" value="Login">
			&nbsp;
			<input type="submit" class="login-button" id="cancel-button" name="cancel-button" value="Cancel">
			<br/><br/>
			<?php if (isset($error_message)) echo $error_message; ?>
		</form>

		<script type="text/javascript">

			window.onload = function()
			{
				update_header_from_lang();
				
				if (localStorage.getItem("HytemLang") == "fr") {
					document.getElementById('login-label').innerHTML = 'Login&nbsp;:';
				} else {
					document.getElementById('login-label').innerHTML = 'Login:';
				}
				if (localStorage.getItem("HytemLang") == "fr") {
					document.getElementById('password-label').innerHTML = 'Mot de passe&nbsp;:';
				} else {
					document.getElementById('password-label').innerHTML = 'Password:';
				}
				if (localStorage.getItem("HytemLang") == "fr") {
					document.getElementById('login-button').value = 'Connexion';
				} else {
					document.getElementById('login-button').value = 'Login';
				}
				if (localStorage.getItem("HytemLang") == "fr") {
					document.getElementById('cancel-button').value = 'Annuler';
				} else {
					document.getElementById('cancel-button').value = 'Cancel';
				}
			}

		</script>
	</body>
</html>
