// ------------------------------------------------------
// Matrix_Canvas class implementation.
//
// Copyright (C) 2021 Logilin (ingenierie@logilin.fr)
//
// ------------------------------------------------------


// Matrix grid and headers colors.

const GRID_COLOR = '#808080';
const HEADERS_TEXT = "#202020";


// Attenuator devices design and colors.

const ATTENUATOR_HORIZONTAL_MARGIN = 0.15;
const ATTENUATOR_VERTICAL_MARGIN = 0.15;

const UNSELECTED_ATTENUATOR_BACKGROUND = "#000040";
const UNSELECTED_ATTENUATOR_TEXT = "#00FFFF";
const UNSELECTED_ATTENUATOR_OUTLINE = UNSELECTED_ATTENUATOR_BACKGROUND;

const SELECTED_ATTENUATOR_BACKGROUND = "#00C0C0";
const SELECTED_ATTENUATOR_TEXT = "#000040";
const SELECTED_ATTENUATOR_OUTLINE = SELECTED_ATTENUATOR_TEXT;

const UNAUTHORIZED_ATTENUATOR_BACKGROUND = "#303030";
const UNAUTHORIZED_ATTENUATOR_TEXT = "#A0A0A0";
const UNAUTHORIZED_ATTENUATOR_OUTLINE = UNAUTHORIZED_ATTENUATOR_BACKGROUND;

// Switch devices design and colors.

const SWITCH_RADIUS = 0.4;

const UNSELECTED_SWITCH_BACKGROUND = "#000040";
const UNSELECTED_SWITCH_TEXT = "#00C0C0";
const UNSELECTED_SWITCH_OUTLINE = "#000040";

const SELECTED_SWITCH_BACKGROUND = "#00C0C0";
const SELECTED_SWITCH_TEXT = "#000040";
const SELECTED_SWITCH_OUTLINE = "#000040";

const UNAUTHORIZED_SWITCH_BACKGROUND = "#303030";
const UNAUTHORIZED_SWITCH_TEXT = "#A0A0A0";
const UNAUTHORIZED_SWITCH_OUTLINE = "#A0A0A0";

// SPST devices design and colors.

const SPST_RADIUS_1 = 0.4;
const SPST_RADIUS_2 = 0.25;

const SPST_SELECTED_OUTER_DISC = "#00C0C0";
const SPST_OUTER_CIRCLE = "#000040";
const SPST_ACTIVATED_INNER_DISC = "#000040";
const SPST_SELECTED_ACTIVATED_INNER_DISC = "#000040";
const SPST_INNER_CIRCLE = "#000040";
const SPST_INNER_TEXT = "#000040";
const SPST_ACTIVATED_INNER_TEXT = "#00C0C0";
const SPST_UNAUTHORIZED_INNER_TEXT = "#A0A0A0";

const SPST_UNAUTHORIZED_OUTER_CIRCLE = "#404040";
const SPST_UNAUTHORIZED_ACTIVATED_INNER_DISC = "#404040";
const SPST_UNAUTHORIZED_INNER_CIRCLE = "#404040";

// Max distance between mouse down and mouse up position
// on canvas to be considered as a click (in square pxels).

const CLICK_MAX_DISTANCE = 128;


var update_in_progress = 0;


function Matrix_Canvas()
{
	this.canvas = document.getElementById("matrix-canvas");
	this.canvas.addEventListener('mousedown', this.mouse_down);
	this.canvas.addEventListener('mouseup', this.mouse_up);
	this.canvas.parent_matrix = this;

	this.nb_rows = Nb_groups;
	this.nb_cols = Devices_per_group;
	this.cell_type = new Array();
	this.cell_value = new Array();
	this.cell_lock_id = new Array();
	this.cell_min_value = new Array();
	this.cell_max_value = new Array();
	this.cell_granularity = new Array();
	this.cell_factor = new Array();
	this.cell_selected = new Array();
	for (var row = 0; row < this.nb_rows; row++){
		this.cell_type[row] = new Array();
		this.cell_value[row] = new Array();
		this.cell_lock_id[row] = new Array();
		this.cell_min_value[row] = new Array();
		this.cell_max_value[row] = new Array();
		this.cell_granularity[row] = new Array();
		this.cell_factor[row] = new Array();
		this.cell_selected[row] = new Array();
		for (var col = 0; col < this.nb_cols; col++) {
			this.cell_type[row][col] = -1;
			this.cell_value[row][col] = -1;
			this.cell_lock_id[row][col] = -1;
			this.cell_min_value[row][col] = 0;
			this.cell_max_value[row][col] = 1;
			this.cell_granularity[row][col] = 1;
			this.cell_factor[row][col] = 1.0;
			this.cell_selected[row][col] = false;
		}
	}
	this.row_header = new Array();
	this.cells_selected_in_matrix = 0;
	this.continuous_cells_selected_in_matrix = 0;
	this.cell_width = 75;
	this.cell_height = 50;
	this.canvas.width = this.cell_width * (this.nb_cols + 1); // +1 because of the headers
	this.canvas.height = this.cell_height * (this.nb_rows + 1);

	if (this.cell_width  > this.cell_height) {
		this.switch_radius = this.cell_height * SWITCH_RADIUS;
		this.spst_radius_1 = this.cell_height * SPST_RADIUS_1;
		this.spst_radius_2 = this.cell_height * SPST_RADIUS_2;
	} else {
		this.switch_radius = this.cell_width * SWITCH_RADIUS;
		this.spst_radius_1 = this.cell_width * SPST_RADIUS_1;
		this.spst_radius_2 = this.cell_width * SPST_RADIUS_2;
	}
}



Matrix_Canvas.prototype.show = function()
{
	document.getElementById("td-matrix-canvas").style.display = '';
	document.getElementById("td-matrix-buttons").style.display = '';
	update_in_progress = 0;
}



Matrix_Canvas.prototype.hide = function()
{
	document.getElementById("td-matrix-canvas").style.display = 'none';
	document.getElementById("td-matrix-buttons").style.display = 'none';
}



Matrix_Canvas.prototype.display = function()
{

	if (! update_in_progress) {
		this.canvas.width = this.canvas.width; // Clear

		this.display_select_all_button();
		this.display_column_headers();
		this.display_row_headers();

		for (var row = 0; row < this.nb_rows; row++) {
			for (var col = 0; col < this.nb_cols; col++) {
				this.display_cell(row, col);
			}
		}
	}
}



Matrix_Canvas.prototype.display_select_all_button = function()
{
	var ctx = this.canvas.getContext("2d");
	ctx.beginPath();

	var img = document.getElementById('all-button-img');
	ctx.drawImage(img, this.cell_width * 0.5 - 20, this.cell_height * 0.5 - 20, 40, 40);
	ctx.stroke();
	ctx.beginPath();
	ctx.lineWidth = 1;
	ctx.strokeStyle = '#000040';
	ctx.moveTo(this.cell_width * 0.5 - 20 - 5, this.cell_height * 0.5 - 20 - 5);
	ctx.lineTo(this.cell_width * 0.5 + 20 + 5, this.cell_height * 0.5 - 20 - 5);
	ctx.lineTo(this.cell_width * 0.5 + 20 + 5, this.cell_height * 0.5 + 20 + 5);
	ctx.lineTo(this.cell_width * 0.5 - 20 - 5, this.cell_height * 0.5 + 20 + 5);
	ctx.lineTo(this.cell_width * 0.5 - 20 - 5, this.cell_height * 0.5 - 20 - 5);
	ctx.stroke();
}



Matrix_Canvas.prototype.display_column_headers = function()
{
	var ctx = this.canvas.getContext("2d");

	ctx.beginPath();
	ctx.fillStyle = HEADERS_TEXT;
	ctx.textAlign = "center";
	ctx.textBaseline = "middle";
	ctx.font = "20px Arial";
	for (var col = 0; col < this.nb_cols; col++)
		ctx.fillText(col + 1, (col + 1 + 0.5) * this.cell_width, 0.5 * this.cell_height);
	ctx.fill();
}



Matrix_Canvas.prototype.display_row_headers = function()
{
	var ctx = this.canvas.getContext("2d");

	ctx.beginPath();
	ctx.fillStyle = HEADERS_TEXT;
	ctx.textAlign = "center";
	ctx.textBaseline = "middle";
	ctx.font = "16px Arial";
	for (var row = 0; row < this.nb_rows; row++)
		ctx.fillText(this.row_header[row], 0.5 * this.cell_width, (row + 1 + 0.5) * this.cell_height);
	ctx.fill();
}



Matrix_Canvas.prototype.display_cell = function(row, col)
{
	switch(this.cell_type[row][col]) {
		case DEVICE_ATTENUATOR:
			this.display_attenuator_cell(row, col);
			break;
		case DEVICE_SWITCH:
			this.display_switch_cell(row, col);
			break;
		case DEVICE_SPST:
			this.display_spst_cell(row, col);
			break;
		default:
			this.display_empty_cell(row, col);
			break;
	}
}



Matrix_Canvas.prototype.display_attenuator_cell = function(row, col)
{
	var ctx = this.canvas.getContext("2d");

	ctx.beginPath();
	ctx.strokeStyle = GRID_COLOR;

	ctx.moveTo(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 0.0) * this.cell_height);
	ctx.lineTo(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + ATTENUATOR_VERTICAL_MARGIN) * this.cell_height);
	ctx.moveTo(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 1.0 - ATTENUATOR_VERTICAL_MARGIN) * this.cell_height);
	ctx.lineTo(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 1.0) * this.cell_height);
	ctx.moveTo(
		(col + 1 + 0.0) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height);
	ctx.lineTo(
		(col + 1 + ATTENUATOR_HORIZONTAL_MARGIN) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height);
	ctx.moveTo(
		(col + 1 + 1.0 - ATTENUATOR_HORIZONTAL_MARGIN) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height);
	ctx.lineTo(
		(col + 1 + 1.0) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height);
	ctx.stroke();

	ctx.beginPath();
	if ((User_permissions[row * Devices_per_group + col] != 0)
	 && (this.cell_lock_id[row][col] == 0)) {
		if (this.cell_selected[row][col])
			ctx.fillStyle = SELECTED_ATTENUATOR_BACKGROUND;
		else
			ctx.fillStyle = UNSELECTED_ATTENUATOR_BACKGROUND;
	} else   {
		ctx.fillStyle = UNAUTHORIZED_ATTENUATOR_BACKGROUND;
	}
	ctx.rect(
		(col + 1 + ATTENUATOR_HORIZONTAL_MARGIN) * this.cell_width,
		(row + 1 + ATTENUATOR_VERTICAL_MARGIN) * this.cell_height,
		(1.0 - 2 * ATTENUATOR_HORIZONTAL_MARGIN) * this.cell_width,
		(1.0 - 2 * ATTENUATOR_VERTICAL_MARGIN) * this.cell_height);
	ctx.fill();

	ctx.beginPath();
	if ((User_permissions[row * Devices_per_group + col] != 0) && (this.cell_lock_id[row][col] == 0)) {
		if (this.cell_selected[row][col])
			ctx.strokeStyle = SELECTED_ATTENUATOR_OUTLINE;
		else
			ctx.strokeStyle = UNSELECTED_ATTENUATOR_OUTLINE;
	} else {
			ctx.strokeStyle = UNAUTHORIZED_ATTENUATOR_OUTLINE;
	}
	ctx.rect(
		(col + 1 + ATTENUATOR_HORIZONTAL_MARGIN) * this.cell_width,
		(row + 1 + ATTENUATOR_VERTICAL_MARGIN) * this.cell_height,
		(1.0 - 2 * ATTENUATOR_HORIZONTAL_MARGIN) * this.cell_width,
		(1.0 - 2 * ATTENUATOR_VERTICAL_MARGIN) * this.cell_height);
	ctx.stroke();

	ctx.beginPath();
	if ((User_permissions[row * Devices_per_group + col] != 0) && (this.cell_lock_id[row][col] == 0)) {
		if (this.cell_selected[row][col])
			ctx.fillStyle = SELECTED_ATTENUATOR_TEXT;
		else
			ctx.fillStyle = UNSELECTED_ATTENUATOR_TEXT;
	} else {
			ctx.fillStyle = UNAUTHORIZED_ATTENUATOR_TEXT;
	}
	ctx.textAlign = "center";
	ctx.textBaseline = "middle";
	ctx.font = "20px Arial";
	ctx.fillText(
		(this.cell_value[row][col] * this.cell_factor[row][col]).toFixed(1),
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height);
	ctx.fill();
}



Matrix_Canvas.prototype.display_switch_cell = function(row, col)
{
	var ctx = this.canvas.getContext("2d");

	ctx.beginPath();
	ctx.strokeStyle = GRID_COLOR;

	ctx.moveTo(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 0.0) * this.cell_height);
	ctx.lineTo(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height - this.switch_radius);
	ctx.moveTo(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height + this.switch_radius);
	ctx.lineTo(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 1.0) * this.cell_height);
 	ctx.moveTo(
		(col + 1 + 0.0) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height);
	ctx.lineTo(
		(col + 1 + 0.5) * this.cell_width - this.switch_radius,
		(row + 1 + 0.5) * this.cell_height);
	ctx.moveTo(
		(col + 1 + 0.5) * this.cell_width + this.switch_radius,
		(row + 1 + 0.5) * this.cell_height);
	ctx.lineTo(
		(col + 1 + 1.0) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height);
	ctx.stroke();

	ctx.beginPath();
	if ((User_permissions[row * Devices_per_group + col] != 0) && (this.cell_lock_id[row][col] == 0)) {
		if (this.cell_selected[row][col])
			ctx.fillStyle = SELECTED_SWITCH_BACKGROUND;
		else
			ctx.fillStyle = UNSELECTED_SWITCH_BACKGROUND;
	} else {
		ctx.fillStyle = UNAUTHORIZED_SWITCH_BACKGROUND;
	}
	ctx.arc(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height,
		this.switch_radius,
		0, 2 * Math.PI);
	ctx.fill();

	ctx.beginPath();
	if ((User_permissions[row * Devices_per_group + col] != 0) && (this.cell_lock_id[row][col] == 0)) {
		if (this.cell_selected[row][col])
			ctx.strokeStyle = SELECTED_SWITCH_OUTLINE;
		else
			ctx.strokeStyle = UNSELECTED_SWITCH_OUTLINE;
	} else {
		ctx.strokeStyle = UNAUTHORIZED_SWITCH_OUTLINE;
	}
	ctx.arc(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height,
		this.switch_radius,
		0, 2 * Math.PI);
	ctx.stroke();

	ctx.beginPath();
	if ((User_permissions[row * Devices_per_group + col] != 0) && (this.cell_lock_id[row][col] == 0)) {
		if (this.cell_selected[row][col])
			ctx.fillStyle = SELECTED_SWITCH_TEXT;
		else
			ctx.fillStyle = UNSELECTED_SWITCH_TEXT;
	} else {
		ctx.fillStyle = UNAUTHORIZED_SWITCH_TEXT;
	}
	ctx.textAlign = "center";
	ctx.textBaseline = "middle";
	ctx.font = "20px Arial";
	ctx.fillText(
		1 + this.cell_value[row][col],
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height);
	ctx.fill();

}



Matrix_Canvas.prototype.display_spst_cell = function(row, col)
{
	var ctx = this.canvas.getContext("2d");

	ctx.beginPath();
	ctx.strokeStyle = GRID_COLOR;

	ctx.moveTo(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 0.0) * this.cell_height);
	ctx.lineTo(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height - this.spst_radius_1);
	ctx.moveTo(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height + this.spst_radius_1);
	ctx.lineTo(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 1.0) * this.cell_height);
	ctx.moveTo(
		(col + 1 + 0.0) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height);
	ctx.lineTo(
		(col + 1 + 0.5) * this.cell_width - this.spst_radius_1,
		(row + 1 + 0.5) * this.cell_height);
	ctx.moveTo(
		(col + 1 + 0.5) * this.cell_width + this.spst_radius_1,
		(row + 1 + 0.5) * this.cell_height);
	ctx.lineTo(
		(col + 1 + 1.0) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height);
	ctx.stroke();

	if (this.cell_selected[row][col]) {
		ctx.beginPath();
		ctx.fillStyle = SPST_SELECTED_OUTER_DISC;
		ctx.arc(
			(col + 1 + 0.5) * this.cell_width,
			(row + 1 + 0.5) * this.cell_height,
			this.spst_radius_1,
			0, 2 * Math.PI);
		ctx.fill();
	}

	ctx.beginPath();

	if ((User_permissions[row * Devices_per_group + col] != 0) && (this.cell_lock_id[row][col] == 0)) {
		ctx.strokeStyle = SPST_OUTER_CIRCLE;
	} else {
		ctx.strokeStyle = SPST_UNAUTHORIZED_OUTER_CIRCLE;
	}

	ctx.arc(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height,
		this.spst_radius_1,
		0, 2 * Math.PI);

	ctx.stroke();


	if (this.cell_value[row][col]) {
		ctx.beginPath();

		if ((User_permissions[row * Devices_per_group + col] != 0) && (this.cell_lock_id[row][col] == 0)) {
			if (this.cell_selected[row][col]) {
				ctx.fillStyle = SPST_SELECTED_ACTIVATED_INNER_DISC;
			} else {
				ctx.fillStyle = SPST_ACTIVATED_INNER_DISC;
			}
		} else {
			ctx.fillStyle = SPST_UNAUTHORIZED_ACTIVATED_INNER_DISC;
		}

		ctx.arc(
			(col + 1 + 0.5) * this.cell_width,
			(row + 1 + 0.5) * this.cell_height,
			this.spst_radius_2,
			0, 2 * Math.PI);
		ctx.fill();
	}

	ctx.beginPath();

	if ((User_permissions[row * Devices_per_group + col] != 0) && (this.cell_lock_id[row][col] == 0)) {
		ctx.strokeStyle = SPST_INNER_CIRCLE;
	} else {
		ctx.strokeStyle = SPST_UNAUTHORIZED_INNER_CIRCLE;
	}

	ctx.arc(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height,
		this.spst_radius_2,
		0, 2 * Math.PI);

	ctx.stroke();

	if (this.cell_value[row][col]) {

		ctx.beginPath();
		if ((User_permissions[row * Devices_per_group + col] != 0) && (this.cell_lock_id[row][col] == 0))
			ctx.fillStyle = SPST_ACTIVATED_INNER_TEXT;
		else
			ctx.fillStyle = SPST_UNAUTHORIZED_INNER_TEXT;
		ctx.textAlign = "center";
		ctx.textBaseline = "middle";
		ctx.font = "bold 10px Arial";

		ctx.fillText("ON",
			(col + 1 + 0.5) * this.cell_width,
			(row + 1 + 0.5) * this.cell_height);
		ctx.fill();
	}
}



Matrix_Canvas.prototype.display_empty_cell = function(row, col)
{
	var ctx = this.canvas.getContext("2d");

	ctx.beginPath();
	ctx.strokeStyle = GRID_COLOR;

	ctx.moveTo(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 0.0) * this.cell_height);
	ctx.lineTo(
		(col + 1 + 0.5) * this.cell_width,
		(row + 1 + 1.0) * this.cell_height);
	ctx.moveTo(
		(col + 1 + 0.0) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height);
	ctx.lineTo(
		(col + 1 + 1.0) * this.cell_width,
		(row + 1 + 0.5) * this.cell_height);
	ctx.stroke();
}



Matrix_Canvas.prototype.mouse_down = function(evt)
{
	evt.preventDefault();

	if ((evt.which == 1) || (evt.button == 1)) {
		var mtrx = this.parent_matrix;

		mtrx.mouse_x = evt.clientX;
		mtrx.mouse_y = evt.clientY;
	}
	return false;
}


Matrix_Canvas.prototype.mouse_up = function(evt)
{
	evt.preventDefault();

	var mtrx = this.parent_matrix;

	if ((mtrx.mouse_x >= 0)
	 && (mtrx.mouse_y >= 0)) {

		mtrx.dist  = (evt.clientX - mtrx.mouse_x) * (evt.clientX - mtrx.mouse_x);
		mtrx.dist += (evt.clientY - mtrx.mouse_y) * (evt.clientY - mtrx.mouse_y);

		if (mtrx.dist < CLICK_MAX_DISTANCE) {

			var mouse_col = parseInt((mtrx.mouse_x - this.getBoundingClientRect().left)/ mtrx.cell_width) - 1;
			var mouse_row = parseInt((mtrx.mouse_y - this.getBoundingClientRect().top)/ mtrx.cell_height) - 1;

			var first_selected = false;
			var new_status = false;
			if ((mouse_col < 0) && (mouse_row < 0)) {
				for (var col = 0; col < mtrx.nb_cols; col++) {
					for (var row = 0; row < mtrx.nb_rows; row++) {
						if (User_permissions[row * Devices_per_group + col] != 0) {
							if (!first_selected) {
								first_selected = true;
								new_status = !mtrx.cell_selected[row][col];
							}
							mtrx.cell_selected[row][col] = new_status;
						}
					}
				}
			} else if (mouse_col < 0) {
				for (var col = 0; col < mtrx.nb_cols; col++) {
					if (User_permissions[mouse_row * Devices_per_group + col] != 0) {
						if (!first_selected) {
							first_selected = true;
							new_status = !mtrx.cell_selected[mouse_row][col];
						}
						mtrx.cell_selected[mouse_row][col] = new_status;
					}
				}
			} else if (mouse_row < 0) {
				for (var row = 0; row < mtrx.nb_rows; row++) {
					if (User_permissions[row * Devices_per_group + mouse_col] != 0) {
						if (!first_selected) {
							first_selected = true;
							new_status = !mtrx.cell_selected[row][mouse_col];
						}
						mtrx.cell_selected[row][mouse_col] = new_status;

					}
				}
			} else {
				if (User_permissions[mouse_row * Devices_per_group + mouse_col] != 0)
					mtrx.cell_selected[mouse_row][mouse_col] = ! mtrx.cell_selected[mouse_row][mouse_col];
			}
			mtrx.compute_cells_selected_in_matrix();
		}
	}
	mtrx.mouse_x = -1;
	mtrx.mouse_y = -1;

	return false;
}



Matrix_Canvas.prototype.compute_cells_selected_in_matrix = function()
{
	this.cells_selected_in_matrix = 0;
	this.continuous_cells_selected_in_matrix = 0;

	for (var row = 0; row < this.nb_rows; row++) {
		for (var col = 0; col < this.nb_cols; col++) {
			if (this.cell_selected[row][col]) {
				this.cells_selected_in_matrix++;
				if (this.cell_type[row][col] == DEVICE_ATTENUATOR)
					this.continuous_cells_selected_in_matrix++;
			}
		}
	}
}



Matrix_Canvas.prototype.set_all_continuous_devices_to = function(value)
{
	var url_line="";
	for (var row = 0; row < this.nb_rows; row++) {
		for (var col = 0; col < this.nb_cols; col++) {
			if ((this.cell_selected[row][col]) && (this.cell_type[row][col] == DEVICE_ATTENUATOR) && (this.cell_lock_id[row][col] == 0)) {
				url_line += "&dev=" + (col + Devices_per_group * row) + "&val=" + value;
			}
		}
	}
	if (url_line != "") {
		update_in_progress = true;
		jQuery.ajax({
			type: "GET",
				url:"cgi-bin/set-values-no-lock?" + url_line,
				dataType: 'text',
				async: true,
				complete: function(jqXHR, textStatus) {
					update_in_progress = false;
					Matrix_canvas.display();
				}
			});
	}
}


Matrix_Canvas.prototype.set_all_devices_to_max = function()
{
	var attenuator_selected = false;
	var switch_selected = false;
	var spst_selected = false;

	var url_line="";

	for (var row = 0; row < this.nb_rows; row++) {
		for (var col = 0; col < this.nb_cols; col++) {
			if (this.cell_selected[row][col]) {
				if (this.cell_type[row][col] == DEVICE_ATTENUATOR)
					attenuator_selected = true;
				if (this.cell_type[row][col] == DEVICE_SWITCH)
					switch_selected = true;
				if (this.cell_type[row][col] == DEVICE_SPST)
					spst_selected = true;
			}
		}
	}

	if (attenuator_selected) {
		for (var row = 0; row < this.nb_rows; row++) {
			for (var col = 0; col < this.nb_cols; col++) {
				if ((this.cell_selected[row][col]) && (this.cell_type[row][col] == DEVICE_ATTENUATOR) && (this.cell_lock_id[row][col] == 0)) {
					url_line += "&dev=" + (col + Devices_per_group * row) + "&val=" + Attenuators_range;
				}
			}
		}
	} else {
		if ((switch_selected) && (! spst_selected)) {
			for (var row = 0; row < this.nb_rows; row++) {
				for (var col = 0; col < this.nb_cols; col++) {
					if ((this.cell_selected[row][col]) && (this.cell_type[row][col] == DEVICE_SWITCH) && (this.cell_lock_id[row][col] == 0)) {
						url_line += "&dev=" + (col + Devices_per_group * row) + "&val=" + (Throws_per_switch - 1);
					}
				}
			}
		} else if ((spst_selected) && (! switch_selected)) {
			if (spst_selected) {
				for (var row = 0; row < this.nb_rows; row++) {
					for (var col = 0; col < this.nb_cols; col++) {
						if ((this.cell_selected[row][col]) && (this.cell_type[row][col] == DEVICE_SPST) && (this.cell_lock_id[row][col] == 0)) {
							url_line += "&dev=" + (col + Devices_per_group * row) + "&val=" + 1;
						}
					}
				}
			}
		}
	}

	if (url_line != "") {
		update_in_progress = true;
		jQuery.ajax({
			type: "GET",
				url:"cgi-bin/set-values-no-lock?" + url_line,
				dataType: 'text',
				async: true,
				complete: function(jqXHR, textStatus) {
					update_in_progress = false;
					Matrix_canvas.display();
				}
			});
	}
}



Matrix_Canvas.prototype.set_all_devices_to_min = function()
{
	var attenuator_selected = false;
	var switch_selected = false;
	var spst_selected = false;

	var url_line="";

	for (var row = 0; row < this.nb_rows; row++) {
		for (var col = 0; col < this.nb_cols; col++) {
			if (this.cell_selected[row][col]) {
				if (this.cell_type[row][col] == DEVICE_ATTENUATOR)
					attenuator_selected = true;
				if (this.cell_type[row][col] == DEVICE_SWITCH)
					switch_selected = true;
				if (this.cell_type[row][col] == DEVICE_SPST)
					spst_selected = true;
			}
		}
	}

	if (attenuator_selected) {
		for (var row = 0; row < this.nb_rows; row++) {
			for (var col = 0; col < this.nb_cols; col++) {
				if ((this.cell_selected[row][col]) && (this.cell_type[row][col] == DEVICE_ATTENUATOR) && (this.cell_lock_id[row][col] == 0)) {
					url_line += "&dev=" + (col + Devices_per_group * row) + "&val=" + 0;
				}
			}
		}
	} else {
		if ((switch_selected) && (! spst_selected)) {
			for (var row = 0; row < this.nb_rows; row++) {
				for (var col = 0; col < this.nb_cols; col++) {
					if ((this.cell_selected[row][col]) && (this.cell_type[row][col] == DEVICE_SWITCH) && (this.cell_lock_id[row][col] == 0)) {
						url_line += "&dev=" + (col + Devices_per_group * row) + "&val=" + 0;
					}
				}
			}
		} else if ((spst_selected) && (! switch_selected)) {
			for (var row = 0; row < this.nb_rows; row++) {
				for (var col = 0; col < this.nb_cols; col++) {
					if ((this.cell_selected[row][col]) && (this.cell_type[row][col] == DEVICE_SPST) && (this.cell_lock_id[row][col] == 0)) {
						url_line += "&dev=" + (col + Devices_per_group * row) + "&val=" + 0;
					}
				}
			}
		}
	}

	if (url_line != "") {
		update_in_progress = true;
		jQuery.ajax({
			type: "GET",
				url:"cgi-bin/set-values-no-lock?" + url_line,
				dataType: 'text',
				async: true,
				complete: function(jqXHR, textStatus) {
					update_in_progress = false;
					Matrix_canvas.display();
				}
			});
	}
}



Matrix_Canvas.prototype.increase_all_devices = function()
{
	var attenuator_selected = false;
	var switch_selected = false;
	var spst_selected = false;

	var url_line="";

	for (var row = 0; row < this.nb_rows; row++) {
		for (var col = 0; col < this.nb_cols; col++) {
			if (this.cell_selected[row][col]) {
				if (this.cell_type[row][col] == DEVICE_ATTENUATOR)
					attenuator_selected = true;
				if (this.cell_type[row][col] == DEVICE_SWITCH)
					switch_selected = true;
				if (this.cell_type[row][col] == DEVICE_SPST)
					spst_selected = true;
			}
		}
	}

	if (attenuator_selected) {
		for (var row = 0; row < this.nb_rows; row++) {
			for (var col = 0; col < this.nb_cols; col++) {
				if ((this.cell_selected[row][col]) && (this.cell_type[row][col] == DEVICE_ATTENUATOR) && (this.cell_lock_id[row][col] == 0)) {
					if (this.cell_value[row][col] < this.cell_max_value[row][col])
						url_line += "&dev=" + (col + Devices_per_group * row) + "&val=" + (this.cell_value[row][col] + this.cell_granularity[row][col]);
				}
			}
		}
	} else {
		if ((switch_selected) && (! spst_selected)) {
			for (var row = 0; row < this.nb_rows; row++) {
				for (var col = 0; col < this.nb_cols; col++) {
					if ((this.cell_selected[row][col]) && (this.cell_type[row][col] == DEVICE_SWITCH) && (this.cell_lock_id[row][col] == 0)) {
						if (this.cell_value[row][col] < this.cell_max_value[row][col])
							url_line += "&dev=" + (col + Devices_per_group * row) + "&val=" + (this.cell_value[row][col] + this.cell_granularity[row][col]);
					}
				}
			}
		} else if ((spst_selected) && (! switch_selected)) {
			for (var row = 0; row < this.nb_rows; row++) {
				for (var col = 0; col < this.nb_cols; col++) {
					if ((this.cell_selected[row][col]) && (this.cell_type[row][col] == DEVICE_SPST) && (this.cell_lock_id[row][col] == 0)) {
						url_line += "&dev=" + (col + Devices_per_group * row) + "&val=1" ;
					}
				}
			}
		}
	}

	if (url_line != "") {
		update_in_progress = true;
		jQuery.ajax({
			type: "GET",
				url:"cgi-bin/set-values-no-lock?" + url_line,
				dataType: 'text',
				async: true,
				complete: function(jqXHR, textStatus) {
					update_in_progress = false;
					Matrix_canvas.display();
				}
			});
	}
}



Matrix_Canvas.prototype.decrease_all_devices = function()
{
	var attenuator_selected = false;
	var switch_selected = false;
	var spst_selected = false;

	var url_line="";

	for (var row = 0; row < this.nb_rows; row++) {
		for (var col = 0; col < this.nb_cols; col++) {
			if (this.cell_selected[row][col]) {
				if (this.cell_type[row][col] == DEVICE_ATTENUATOR)
					attenuator_selected = true;
				if (this.cell_type[row][col] == DEVICE_SWITCH)
					switch_selected = true;
				if (this.cell_type[row][col] == DEVICE_SPST)
					spst_selected = true;
			}
		}
	}

	if (attenuator_selected) {
		for (var row = 0; row < this.nb_rows; row++) {
			for (var col = 0; col < this.nb_cols; col++) {
				if ((this.cell_selected[row][col]) && (this.cell_type[row][col] == DEVICE_ATTENUATOR) && (this.cell_lock_id[row][col] == 0)) {
					if (this.cell_value[row][col] > this.cell_min_value[row][col])
						url_line += "&dev=" + (col + Devices_per_group * row) + "&val=" + (this.cell_value[row][col] - this.cell_granularity[row][col]);
				}
			}
		}
	} else {
		if ((switch_selected) && (! spst_selected)) {
			for (var row = 0; row < this.nb_rows; row++) {
				for (var col = 0; col < this.nb_cols; col++) {
					if ((this.cell_selected[row][col]) && (this.cell_type[row][col] == DEVICE_SWITCH) && (this.cell_lock_id[row][col] == 0)) {
						if (this.cell_value[row][col] > this.cell_min_value[row][col])
							url_line += "&dev=" + (col + Devices_per_group * row) + "&val=" + (this.cell_value[row][col] - this.cell_granularity[row][col]);
					}
				}
			}
		} else if ((spst_selected) && (! switch_selected)) {
			for (var row = 0; row < this.nb_rows; row++) {
				for (var col = 0; col < this.nb_cols; col++) {
					if ((this.cell_selected[row][col]) && (this.cell_type[row][col] == DEVICE_SPST) && (this.cell_lock_id[row][col] == 0)) {
						url_line += "&dev=" + (col + Devices_per_group * row) + "&val=0" ;
					}
				}
			}
		}
	}

	if (url_line != "") {
		update_in_progress = true;
		jQuery.ajax({
			type: "GET",
				url:"cgi-bin/set-values-no-lock?" + url_line,
				dataType: 'text',
				async: true,
				complete: function(jqXHR, textStatus) {
					update_in_progress = false;
					Matrix_canvas.display();
				}
			});
	}
}
