	#include <fcntl.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <stdint.h>
	#include <string.h>
	#include <unistd.h>
	#include <sys/stat.h>
	#include <sys/mman.h>

	#include "config.h"

	#define BOARD_NAME_FILE "/etc/hytem-board-name"
	#define BOARD_NAME_MAX_LENGTH  128

int main(void)
{
	int fd;
	FILE *fp;
	char line[BOARD_NAME_MAX_LENGTH];
	config_global_parameters_t *params = NULL;

	fprintf(stdout, "Content-type: text/plain\r\n\r\n");

	fd = shm_open(DEVICES_SHM_FILE, O_RDONLY, 0644);
	if (fd < 0) {
		fprintf(stdout, "???");
		return 0;
	}

	params = (config_global_parameters_t *) mmap(NULL, CONFIG_GLOBAL_PARAMETERS_SIZE, PROT_READ, MAP_SHARED, fd, 0);
	if (params == MAP_FAILED) {
		fprintf(stdout, "???");
		return 0;
	}
	close (fd);

	if (params->version[3] == 0)
		fprintf(stdout, "%d.%d.%d\r\n", params->version[0], params->version[1], params->version[2]);
	else if (params->version[3] == 1)
		fprintf(stdout, "%d.%d-pre-%d\r\n", params->version[0], params->version[1], params->version[2]);
	else 
		fprintf(stdout, "%d.%d-dev-%d\r\n", params->version[0], params->version[1], params->version[2]);

	fp = fopen(BOARD_NAME_FILE, "r");
	if ((fp != NULL)
	 && (fgets(line, BOARD_NAME_MAX_LENGTH -1, fp) != NULL)
	 && (line[0] != '\0')) {
		line[strlen(line) - 1] = '\0';
		fprintf(stdout, "%s\r\n", line);
	} else {
		fprintf(stdout, "unknown\r\n");
	}
	fclose(fp);


	return 0;
}
