<?php
	/*
		Web HMI for the Hytem devices control system.

		Design and implementation by Logilin (www.logilin.fr)
	*/
	require('hytem-header.php');
?>
<!DOCTYPE html>
<html>
	<head>
		<?php  fill_html_head_block(); ?>
	</head>

	<body onselectstart='return false;' oncontextmenu='return false;' style='overflow-y: scroll; overflow-x: auto; width: 99%;' >

		<?php fill_html_header_block($Devices_name); ?>
		<?php fill_tabs_block("index", "unselect_all_canvases()"); ?>

		<div class="content">
			<?php
				unset($output);
				exec("/home/www/cgi-bin/get-number-of-groups", $output, $retval);
				$Nb_groups = (int)($output[2]);

				unset($output);
				exec("/home/www/cgi-bin/get-devices-per-group", $output, $retval);
				$Devices_per_group = (int)($output[2]);
			?>

			<table id="devices-table">
				<tr>
					<td id="groups-menu" style='vertical-align: top'>
						<table id="groups-table">
						<?php
							if ($Nb_groups <= 4) {
								for ($i=0; $i < $Nb_groups; $i ++){
									echo "<tr>";
									echo "<td class='group_name' id='group-name-$i'>".($i+1)."</td>";
									echo "</tr>";
									echo "<tr><td class='group_name_separator'></td></tr>";
								}
							} else if ($Nb_groups <= 16) {
								$n = floor(($Nb_groups + 1) / 2);
								for ($i=0; $i < $n; $i ++){
									echo "<tr>";
									echo "<td class='group_name' id='group-name-$i'>".($i+1)."</td>";
									if (($i + $n) < $Nb_groups) {
										echo "<td class='group_name' id='group-name-".($i+$n)."'>".($i+$n+1)."</td>";
									}
									echo "</tr>";
									echo "<tr><td class='group_name_separator'></td></tr>";
								}
							} else {
								$n = floor(($Nb_groups + 3) / 4);
								for ($i=0; $i < $n; $i ++){
									echo "<tr>";
									echo "<td class='group_name' id='group-name-$i'>".($i+1)."</td>";
									if (($i + $n) < $Nb_groups) {
										echo "<td class='group_name' id='group-name-".($i+$n)."'>".($i+$n+1)."</td>";
									}
									if (($i + 2 * $n) < $Nb_groups) {
										echo "<td class='group_name' id='group-name-".($i+ 2 * $n)."'>".($i + 2 * $n + 1)."</td>";
									}
									if (($i + 3 * $n) < $Nb_groups) {
										echo "<td class='group_name' id='group-name-".($i+ 3 * $n)."'>".($i + 3 * $n + 1)."</td>";
									}
									echo "</tr>";
									echo "<tr><td class='group_name_separator'></td></tr>";
								}
							}
						?>
						</table>
					</td>
					<td id="td-dev-table" style='vertical-align: top'>
						<table id="users-dev-table" class="users-dev-table">
						<?php
							echo "<tr>";
							for ($i = 0; $i < $Devices_per_group; $i ++)
								echo "<td class='dev-name'  id='dev-name-$i' >DEV$i</td>";
							echo "</tr><tr>";
							for ($i = 0; $i < $Devices_per_group; $i ++)
								echo "<td class='dev-value' id='dev-value-$i'> ??? </td>";
							echo "</tr><tr>";
							for ($i = 0; $i < $Devices_per_group; $i ++) {
								echo "<td id='dev-td-$i'><div class='cnv-div' id='dev-div-$i'>";
								echo "<canvas class='dev-cnv' id='dev-cnv-$i' width='50' height='500'>Please use a browser compatible with HTML5/Canvas widget.</canvas>";
								echo "<canvas class='dev-bkg' id='dev-bkg-$i' width='50' height='500'></canvas>";
								echo "<canvas class='dev-txt' id='dev-txt-$i' width='50' height='500'></canvas>";
								echo "</div></td>";
							}
						?>
						</table>
					</td>
					<td id="td-dev-buttons" style='vertical-align: top'>
						<table id="devices-right-side-table">
							<tr>
								<td>
									<img class='devices-side-buttons' src='png/bt-view.png'  height=40 width=40 alt='View' id='view-button-img' onclick='view_button_cb();' />
								</td>
							</tr>
							<tr>
								<td>
									<img class='devices-side-buttons' src='png/bt-max.gif'  height=40 width=40 alt='Max' id='maxv-button-img' onclick='max_button_cb();' />
								</td>
							</tr>
							<tr>
								<td>
									<img class='devices-side-buttons' src='png/bt-more.gif'  height=40 width=40 alt='Plus' id='plus-button-img' />
								</td>
							</tr>
							<tr>
								<td>
									<img class='devices-side-buttons' src='png/bt-cross.gif'  height=40 width=40 alt='Handover' id='handover-button-img' />
								</td>
							</tr>
							<tr>
								<td>
									<img class='devices-side-buttons' src='png/bt-less.gif'  height=40 width=40 alt='Minus' id='minus-button-img' />
								</td>
							</tr>
							<tr>
								<td>
									<img class='devices-side-buttons' src='png/bt-min.gif'  height=40 width=40 alt='Min' id='minv-button-img' onclick='min_button_cb();' />
								</td>
							</tr>
							<tr>
								<td>
									<img class='devices-side-buttons' src='png/bt-all.gif' height=40 width=40 alt='All' id='all-button-img' onclick='select_all_button_cb();' />
								</td>
							</tr>
						</table>
					</td>
					<td id="td-matrix-canvas" style='vertical-align: top'>
						<div class='matrix-div'>
							<canvas id='matrix-canvas' width='500' height='500'>
								Please use a browser compatible with HTML5/Canvas widget.
							</canvas>
						</div>
					</td>
					<td id="td-matrix-buttons" style='vertical-align: top'>
						<table id="devices-right-side-table">
							<tr>
								<td>
									<img class='devices-side-buttons' src='png/bt-view.png'  height=40 width=40 alt='View' id='view-button-img' onclick='view_button_cb();' />
								</td>
							</tr>
							<tr>
								<td>
									<img class='devices-side-buttons' src='png/bt-max.gif'  height=40 width=40 alt='Max' id='maxm-button-img' onclick='matrix_max_button_cb();' />
								</td>
							</tr>
							<tr>
								<td>
									<img class='devices-side-buttons' src='png/bt-more.gif'  height=40 width=40 alt='Plus' id='plusm-button-img' onclick='matrix_plus_button_cb();' />
								</td>
							</tr>
							<tr>
								<td>
									<img class='devices-side-buttons' src='png/bt-edit.png'  height=40 width=40 alt='Max' id='edit-button-img' onclick='matrix_edit_button_cb();' />
								</td>
							</tr>
							<tr>
								<td>
									<img class='devices-side-buttons' src='png/bt-less.gif'  height=40 width=40 alt='Minus' id='minusm-button-img' onclick='matrix_minus_button_cb();' />
								</td>
							</tr>
							<tr>
								<td>
									<img class='devices-side-buttons' src='png/bt-min.gif'  height=40 width=40 alt='Min' id='minm-button-img' onclick='matrix_min_button_cb();' />
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</div>
		<div id="input-value-dialog" title="Device value" hidden >
			<p class="input-value-dialog_tip"></p>
			<form action="" method="post">
				<fieldset>
					<label for="input-value-content" id='input-value-label'>Value:</label>
					<input type="text" id="input-value-content" name="input-value-content" value="" class="text ui-widget-content ui-corner-all">
					<input type="submit" tabindex="-1" style="position:absolute; top:-1000px">
				</fieldset>
			</form>
		</div>


		<script type="text/javascript" src="js/device-canvas.js"></script>
		<script type="text/javascript" src="js/matrix-canvas.js"></script>

		<script type="text/javascript">

			// The number of groups.
			var Nb_groups   = <?php echo $Nb_groups;   ?>;

			// The number of canvases.
			var Devices_per_group = <?php echo $Devices_per_group; ?>;

			// The currently selected group (set by the group_name_cb() callback).
			var Current_group = 0;

			// The attenuators range and the number of throws per switch(updated by refresh_devices).
			var Attenuators_range = 0;
			var Throws_per_switch = 0;
			var Attenuators_display_factor = 0.01;

			// The position of the Local/Remote switch (updated by refresh_devices).
			var Switch_on_remote_position = false;

			var Setting_devices = false;

			// An array of Nb_groups * Devices_per_group integers.
			// user_permissions[n] = 1 if the current user is allowed to access device "n",
			// 0 otherwise.
			var User_permissions = null;

			var First_call = true;

			// Drawing constant.
			const Canvas_margin = 8;

			const Backcolor_switch_on_local = '#808080';
			const Fillcolor_switch_on_local = '#A0A040';
			const Drawcolor_switch_on_local = '#40407F';

			const Backcolor_locked_by_ourself = '#D0D010';
			const Fillcolor_locked_by_ourself = '#FFFF80';
			const Drawcolor_locked_by_ourself = '#101020';

			const Backcolor_locked_by_someone_else = '#909090';
			const Fillcolor_locked_by_someone_else = '#A0A040';
			const Drawcolor_locked_by_someone_else = '#40407F';

			const Backcolor_free_but_not_allowed = '#A0A0A0';
			const Fillcolor_free_but_not_allowed = '#A0A040';
			const Drawcolor_free_but_not_allowed = '#40407F';

			const Backcolor_free_for_us = '#D0D0FF';
			const Fillcolor_free_for_us = '#FFFF00';
			const Drawcolor_free_for_us = '#40407F';

			const Fillcolor_devices_background = '#8080BF';
			const Drawcolor_devices_background = '#40407F';

			const DEVICE_ATTENUATOR = 1;
			const DEVICE_SWITCH = 2;
			const DEVICE_SPST = 4;

			const Attenuators_handle_grab_value_delta = 200; /* 2dB */

			const DEVICES_DISPLAY_MODE = 0;
			const MATRIX_DISPLAY_MODE = 1;

			var Current_display_mode = DEVICES_DISPLAY_MODE;


			// Array of Device_canvas instances.
			var Devices_canvases;

			var Matrix_canvas;

			// Variables used by mouse down/up events.
			var Device_canvas_mouse_down = null;
			var Device_canvas_mouse_move = null;


			/// \brief Page initialization function.
			///
			window.onload = function()
			{
				update_header_from_lang();

				init_input_value_dialog();

				if (localStorage.getItem("HytemLang") == "fr") {

					document.getElementById('ui-id-1').innerHTML="Valeur &eacute;quipement";
					document.getElementById('input-value-label').innerHTML="Valeur&nbsp;:";
					document.getElementById('input-value-dialog-cancel').innerHTML="<span class='ui-button-text'>Annuler</span>";
				}

				if (Nb_groups > 1) {
					for (var i = 0; i < Nb_groups; i ++) {
						var btn = document.getElementById('group-name-' + i);
						btn.number = i;
						if (btn.number == Current_group)
							btn.className = "group_name_selected"
						else
							btn.className = "group_name"
						btn.addEventListener('click', group_name_cb);
					}
				} else {
					document.getElementById("groups-menu").style.display = 'none';
				}

				load_user_permissions();

				Devices_canvases = new Array();

				for (var i = 0; i < Devices_per_group; i ++) {
					Devices_canvases[i] = new Device_canvas(i);
				}

				 document.getElementById('plus-button-img').addEventListener('mousedown',  plus_button_down_cb);
				 document.getElementById('plus-button-img').addEventListener('mouseup',    plus_button_up_cb);
				 document.getElementById('plus-button-img').addEventListener('mouseleave', plus_button_leave_cb);

				 document.getElementById('handover-button-img').addEventListener('mousedown',  handover_button_down_cb);
				 document.getElementById('handover-button-img').addEventListener('mouseup',    handover_button_up_cb);
				 document.getElementById('handover-button-img').addEventListener('mouseleave', handover_button_leave_cb);

				 document.getElementById('minus-button-img').addEventListener('mousedown',  minus_button_down_cb);
				 document.getElementById('minus-button-img').addEventListener('mouseup',    minus_button_up_cb);
				 document.getElementById('minus-button-img').addEventListener('mouseleave', minus_button_leave_cb);

				// The following events are handled at document level to emulate a
				// portable CaptureMouse()/ReleaseMouse() behavior, with the
				// help of Device_canvas_mouse_down and Device_canvas_mouse_move
				// global variables.
				document.addEventListener('mousemove', Device_canvas_mouse_move_cb);
				document.addEventListener('mouseup',   Device_canvas_mouse_up_cb);

				Matrix_canvas = new Matrix_Canvas();

				if (localStorage.getItem("HytemDefaultDisplay") ==  "matrix") {

					Current_display_mode = MATRIX_DISPLAY_MODE;
					document.getElementById("groups-menu").style.display = 'none';
					document.getElementById("td-dev-table").style.display = 'none';
					document.getElementById("td-dev-buttons").style.display = 'none';
					Matrix_canvas.show();

				} else {

					Current_display_mode = DEVICES_DISPLAY_MODE;
					if (Nb_groups > 1)
						document.getElementById("groups-menu").style.display = '';
					document.getElementById("td-dev-table").style.display = '';
					document.getElementById("td-dev-buttons").style.display = '';
					Matrix_canvas.hide();
					enable_group_buttons();
					select_group(Current_group);
				}

				window.addEventListener('beforeunload', function (e) {
					unselect_all_canvases();
					delete e['returnValue'];
				});

				window.addEventListener('unload', function (e) {
					unselect_all_canvases();
				});

				refresh_devices();
				draw_backgrounds();
				refresh_device_locks();
			};


			/* Small hack for Linux chromium browser that doesn't send Unload event on F5. */

			document.onkeydown = capturekey;
			document.onkeypress = capturekey;
			document.onkeyup = capturekey;

			function capturekey(e)
			{
				e = e || window.event;
				if (e.code == 'F5') {
					unselect_all_canvases();
				}
			}

			/// \brief  Load the user permissions array if the multiusers option is enabled.
			///
			function load_user_permissions()
			{
				User_permissions = new Array();

				if (<?php print $Multiusers ?> == 0) {

					for (var i = 0; i < Nb_groups * Devices_per_group; i++)
						User_permissions[i] = 1;

				} else {

					if (<?php print $Logged_in ?> == 0) {

						for (var i = 0; i < Nb_groups * Devices_per_group; i++)
							User_permissions[i] = 0;

					} else {
						var xhr = get_xhr_object();
						if (xhr != null) {
							xhr.onreadystatechange = function() {
								if ((xhr.readyState == 4) && (xhr.status == 200)) {
									var response = xhr.responseText;
									for (var i = 0; i < response.length; i ++) {
										User_permissions[i] = (response.charAt(i) == 0) ? 0 : 1;
									}
									for (var i = response.length; i < Nb_groups * Devices_per_group; i ++)
										User_permissions[i] = 0;
								}
							};
							xhr.open("GET", "cgi-bin/get-permissions?id=<?php print $_SESSION['LOGIN'] ?>", true);
							xhr.send();
						}
					}
				}
			}



			/// \brief Callback for click on a group button.
			///
			function group_name_cb(evt)
			{
				evt.preventDefault();
				if (evt.target.number == Current_group)
					return false;
				select_group(evt.target.number);
			}



			function enable_group_buttons()
			{
				if (Current_display_mode != DEVICES_DISPLAY_MODE)
					return 0;

				if (Nb_groups > 1) {
					var first = -1;
					for (var i = 0; i < Nb_groups; i ++) {
						var btn = document.getElementById('group-name-' + i);
						var empty = false;
						if (Matrix_canvas.cells_selected_in_matrix != 0) {
							empty = true;
							for (var j = 0; j < Devices_per_group; j++) {
								if (Matrix_canvas.cell_selected[i][j]) {
									empty = false;
									break;
								}
							}
						}
						if (empty) {
							btn.style.display = 'none';
						}
						else {
							btn.style.display = '';
							if (first < 0)
								first = i;
						}
					}
					return first;
				} else {
					document.getElementById("groups-menu").style.display = 'none';
					return 0;
				}
			}



			function select_group(group)
			{
				if (Current_display_mode != DEVICES_DISPLAY_MODE)
					return false;

				unselect_all_canvases();

				document.getElementById("group-name-" + Current_group).className = "group_name";
				document.getElementById("group-name-" + group).className = "group_name_selected";
				Current_group = group;

				for (i = 0; i < Devices_per_group; i ++) {
					dev_cnv  = Devices_canvases[i];
					if ((Matrix_canvas.cells_selected_in_matrix == 0)
					 || (Matrix_canvas.cell_selected[Current_group][i]))
						dev_cnv.show();
					else
						dev_cnv.hide();
				}

				First_call = true;
				refresh_devices();
				draw_backgrounds();

				return false;
			};



			function Device_canvas_mouse_down_cb(evt)
			{
				evt.preventDefault();

				if (Current_display_mode != DEVICES_DISPLAY_MODE)
					return false;

				// Check that left button is pressed alone.
				if ((evt.which != 1) && (evt.button != 1))
					return false;

				// Check that the switch is on "Remote"
				if (! Switch_on_remote_position)
					return false;

				var dev_cnv = evt.target.dev_cnv;

				// Check the user permission for the canvas.
				if (User_permissions[Current_group * Devices_per_group + dev_cnv.number] == 0)
					return false;

				// For attenuators, start a device move only if grabbed on the "handle".
				if (dev_cnv.device_type == DEVICE_ATTENUATOR) {
					var value = dev_cnv.min_value + (1 - (evt.clientY - dev_cnv.y_offset - Canvas_margin) / (dev_cnv.canvas.height - 2 * Canvas_margin)) * (dev_cnv.max_value - dev_cnv.min_value);
					if (Math.abs(value - dev_cnv.value) < Attenuators_handle_grab_value_delta) {
						Device_canvas_mouse_move = dev_cnv;
						Device_canvas_mouse_move.moved = 0;
					}
				}

				// Store the canvas on which the mouse press starts.
				Device_canvas_mouse_down = dev_cnv;

				return false;
			}



			/// \brief Callback for mouse button release event.
			///
			function Device_canvas_mouse_up_cb(evt)
			{
				evt.preventDefault();

				if (Current_display_mode != DEVICES_DISPLAY_MODE)
					return false;

				if (Device_canvas_mouse_down == null)
					return false;

				// Small moves...
				if ((Device_canvas_mouse_move == null) || (Device_canvas_mouse_move.moved < 3)) {
					Device_canvas_mouse_down.click(evt.clientX, evt.clientY);
				}

				Device_canvas_mouse_move = null;
				Device_canvas_mouse_down = null;

				return false;
			}




			/// \brief Callback for mouse move event.
			///
			function Device_canvas_mouse_move_cb(evt)
			{
				evt.preventDefault();

				if (Current_display_mode != DEVICES_DISPLAY_MODE)
					return false;

				if (! Switch_on_remote_position)
					return false;

				if (Device_canvas_mouse_move == null)
					return false;

				// Increase the mouse move length to differentiate click and cursor movements.
				Device_canvas_mouse_move.moved ++;
				if (! Device_canvas_mouse_move.selected)
					return false;

				if (Setting_devices)
					return false;

				// Compute the new value and display it.

				var i;
				var dev_cnv;
				var new_value;
				var delta_value;

				// Attenuators
				new_value = Device_canvas_mouse_move.min_value
				          + (1 - (evt.clientY - Device_canvas_mouse_move.y_offset - Canvas_margin) / (Device_canvas_mouse_move.canvas.height - 2 * Canvas_margin))
				          * (Device_canvas_mouse_move.max_value - Device_canvas_mouse_move.min_value);

				new_value = Device_canvas_mouse_move.granularity * parseInt(new_value / Device_canvas_mouse_move.granularity);
				var delta_value = new_value - Device_canvas_mouse_move.value;
				for (i = 0; i < Devices_per_group; i ++) {
					dev_cnv  = Devices_canvases[i];
					if (dev_cnv.device_type == DEVICE_ATTENUATOR) {
						if (dev_cnv.selected) {
							if (dev_cnv.value + delta_value < 0)
								delta_value = -dev_cnv.value;
							if (dev_cnv.value  + delta_value > dev_cnv.max_value)
								delta_value = dev_cnv.max_value - dev_cnv.value;
						}
					}
				}
				for (i = 0; i < Devices_per_group; i ++) {
					dev_cnv  = Devices_canvases[i];
					if (dev_cnv.device_type == DEVICE_ATTENUATOR) {
						if (dev_cnv.selected) {
							dev_cnv.draw_status((dev_cnv.value + delta_value), true);
						}
					}
				}
				// Send all devices values.
				set_devices();
				return false;
			}



			function view_button_cb(evt)
			{
				if (Current_display_mode == DEVICES_DISPLAY_MODE) {

					Current_display_mode = MATRIX_DISPLAY_MODE;

					document.getElementById("groups-menu").style.display = 'none';
					document.getElementById("td-dev-table").style.display = 'none';
					document.getElementById("td-dev-buttons").style.display = 'none';
					unselect_all_canvases();
					localStorage.setItem("HytemDefaultDisplay", "matrix");
					Matrix_canvas.show();

				} else {

					Current_display_mode = DEVICES_DISPLAY_MODE;

					if (Nb_groups > 1)
						document.getElementById("groups-menu").style.display = '';
					document.getElementById("td-dev-table").style.display = '';
					document.getElementById("td-dev-buttons").style.display = '';
					Matrix_canvas.hide();
					localStorage.setItem("HytemDefaultDisplay", "devices");
					var group = enable_group_buttons();
					select_group(group);
				}
				return false;
			}


			/// \brief Repetition period (in millisec) for mouse actions.
			///
			var MOUSE_REPEAT_PERIOD = 50;

			/// \brief Repetition delay (in millisec) after first action.
			///
			var MOUSE_REPEAT_DELAY = 800;


			// ------------- The `plus` button handling ---------

			/// \brief  Flag indicating if a `plus` action is currently running.
			var plus_button_action_running = false;

			/// \brief  The repetition delay for `plus` button.
			var plus_button_delay;

			/// \brief  The `plus` button timer.
			var plus_timer;


			/// \brief  Callback for the mouse down event on the `plus` button.
			///
			function plus_button_down_cb(evt)
			{
				if (Setting_devices)
					return false;

				if ((! plus_button_action_running) && (left_button_in_event(evt))) {
					plus_button_action_running = true;
					plus_button_delay = MOUSE_REPEAT_DELAY;
					plus_button_action();
				}
				return false;
			}



			/// \brief Callback for the mouse up event on the `plus` button.
			///
			function plus_button_up_cb(evt)
			{
				if ((plus_button_action_running) && (left_button_in_event(evt)))
					plus_button_action_running = false;
				clearTimeout(plus_timer);
				return false;
			}



			/// \brief Callback for the mouse leave event on the `plus` button.
			///
			function plus_button_leave_cb(evt)
			{
				if (plus_button_action_running)
					plus_button_action_running = false;
				return false;
			}



			/// \brief Main action for the `plus` button.
			///
			function plus_button_action()
			{
				if (plus_button_action_running) {
					if (! Setting_devices) {
						Setting_devices = true;

						var i;
						var attenuator_selected = false;
						var switch_selected = false;
						var spst_selected = false;

						for (i = 0; i < Devices_per_group; i ++) {
							var dev_cnv = Devices_canvases[i];
							if (dev_cnv.selected) {
								if (dev_cnv.device_type == DEVICE_ATTENUATOR)
									attenuator_selected = true;
								if (dev_cnv.device_type == DEVICE_SWITCH)
									switch_selected = true;
								if (dev_cnv.device_type == DEVICE_SPST)
									spst_selected = true;
							}
						}

						if (attenuator_selected) {
							for (i = 0; i < Devices_per_group; i ++) {
								var dev_cnv  = Devices_canvases[i];
								if (dev_cnv.device_type == DEVICE_ATTENUATOR) {
									if (dev_cnv.selected) {
										if (dev_cnv.value < dev_cnv.max_value)
											dev_cnv.draw_status(dev_cnv.value + dev_cnv.granularity, true);
									}
								}
							}
						} else {
							if ((switch_selected) && (! spst_selected)) {
								for (i = 0; i < Devices_per_group; i ++) {
									var dev_cnv = Devices_canvases[i];
									if ((dev_cnv.device_type == DEVICE_SWITCH) && (dev_cnv.selected))
										if (dev_cnv.value < dev_cnv.max_value)
											dev_cnv.draw_status(dev_cnv.value + 1, true);
								}
							} else if ((spst_selected) && (! switch_selected)) {
								for (i = 0; i < Devices_per_group; i ++) {
									var dev_cnv = Devices_canvases[i];
									if ((dev_cnv.device_type == DEVICE_SPST) && (dev_cnv.selected))
										dev_cnv.draw_status(1, true);
								}
							}
						}
						set_devices();
					}
					plus_timer = setTimeout(plus_button_action, plus_button_delay);
					plus_button_delay = MOUSE_REPEAT_PERIOD;
				}
			}


			// ------------- The `minus` button handling ---------

			/// \brief  Flag indicating if a `minus` action is currently running.
			var minus_button_action_running = false;

			/// \brief the repetition delay for `minus` button.
			var minus_button_delay;

			/// \brief  The `minus` button timer.
			var minus_timer;


			/// \brief Callback for the mouse down event on the `minus` button.
			///
			function minus_button_down_cb(evt)
			{
				if (Setting_devices)
					return false;
				if ((! minus_button_action_running) && (left_button_in_event(evt))) {
					minus_button_action_running = true;
					minus_button_delay = MOUSE_REPEAT_DELAY;
					minus_button_action();
				}
				return false;
			}



			/// \brief Callback for the mouse up event on the `minus` button.
			///
			function minus_button_up_cb(evt)
			{
				if ((minus_button_action_running) && (left_button_in_event(evt)))
					minus_button_action_running = false;
				clearTimeout(minus_timer);
				return false;
			}



			/// \brief Callback for the mouse leave event on the `minus` button.
			///
			function minus_button_leave_cb(evt)
			{
				if (minus_button_action_running)
					minus_button_action_running = false;
				return false;
			}



			/// \brief Main action for the `minus` button.
			///
			function minus_button_action()
			{
				if (minus_button_action_running) {
					if (! Setting_devices) {
						Setting_devices = true;
						var i;
						var attenuator_selected = false;
						var switch_selected = false;
						var spst_selected = false;

						for (i = 0; i < Devices_per_group; i ++) {
							var dev_cnv = Devices_canvases[i];
							if (dev_cnv.selected) {
								if (dev_cnv.device_type == DEVICE_ATTENUATOR)
									attenuator_selected = true;
								if (dev_cnv.device_type == DEVICE_SWITCH)
									switch_selected = true;
								if (dev_cnv.device_type == DEVICE_SPST)
									spst_selected = true;
							}
						}

						if (attenuator_selected) {
							for (i = 0; i < Devices_per_group; i ++) {
								var dev_cnv  = Devices_canvases[i];
								if (dev_cnv.device_type == DEVICE_ATTENUATOR) {
									if (dev_cnv.selected) {
										if (dev_cnv.value > dev_cnv.min_value)
											dev_cnv.draw_status(dev_cnv.value - dev_cnv.granularity, true);
									}
								}
							}
						} else {
							if ((switch_selected) && (! spst_selected)) {
								for (i = 0; i < Devices_per_group; i ++) {
									var dev_cnv = Devices_canvases[i];
									if ((dev_cnv.device_type == DEVICE_SWITCH) && (dev_cnv.selected))
										if (dev_cnv.value > dev_cnv.min_value)
											dev_cnv.draw_status(dev_cnv.value - 1, true);
								}
							} else if ((spst_selected) && (! switch_selected)) {
								for (i = 0; i < Devices_per_group; i ++) {
									var dev_cnv = Devices_canvases[i];
									if ((dev_cnv.device_type == DEVICE_SPST) && (dev_cnv.selected))
										dev_cnv.draw_status(0, true);
								}
							}
						}
						set_devices();
					}
					minus_timer = setTimeout(minus_button_action, minus_button_delay);
					minus_button_delay = MOUSE_REPEAT_PERIOD;
				}
			}


			// ------------- The "handover" button handling ---------

			/// \brief  Flag indicating if a "handover" action is currently running.
			var handover_button_action_running = false;

			/// \brief the repetition delay for handover button.
			var handover_button_delay;

			/// \brief  The `handover` button timer.
			var handover_timer;

			var handover_direction_computed = false;

			var handover_refresh_time = 0;


			/// \brief Callback for the mouse down event on the "handover" button.
			///
			function handover_button_down_cb(evt)
			{
				if (Setting_devices)
					return false;

				if ((! handover_button_action_running) && (left_button_in_event(evt))) {
					handover_refresh_time = 0;
					handover_button_action_running = true;
					if (! handover_direction_computed)
						handover_compute_direction();
					handover_button_delay = MOUSE_REPEAT_DELAY;
					handover_button_action();
				}

				return false;
			}



			/// \brief Callback for the mouse up event on the "handover" button.
			///
			function handover_button_up_cb(evt)
			{
				if ((handover_button_action_running) && (left_button_in_event(evt)))
					handover_button_action_running = false;

				handover_direction_computed = false;
				clearTimeout(handover_timer);

				return false;
			}



			/// \brief Callback for the mouse leave event on the "handover" button.
			///
			function handover_button_leave_cb(evt)
			{
				if (handover_button_action_running)
					handover_button_action_running = false;

				return false;
			}



			/// \brief Main action for the "handover" button.
			///
			function handover_button_action()
			{
				if (handover_button_action_running) {
					if (! Setting_devices) {
						var i;
						for (i = 0; i < Devices_per_group; i ++) {
							var dev_cnv  = Devices_canvases[i];
							if (dev_cnv.device_type == DEVICE_ATTENUATOR) {
								if (dev_cnv.selected) {
									if (dev_cnv.value + dev_cnv.handover_direction * dev_cnv.granularity > dev_cnv.max_value) {
										handover_compute_direction();
										break;
									}
									if (dev_cnv.value + dev_cnv.handover_direction * dev_cnv.granularity < dev_cnv.min_value) {
										handover_compute_direction();
										break;
									}
								}
							}
						}
						for (i = 0; i < Devices_per_group; i ++) {
							var dev_cnv = Devices_canvases[i];
							if (dev_cnv.device_type == DEVICE_ATTENUATOR) {
								if (dev_cnv.selected) {
									if ((dev_cnv.value + dev_cnv.handover_direction * dev_cnv.granularity <= dev_cnv.max_value)
									 && (dev_cnv.value + dev_cnv.handover_direction * dev_cnv.granularity >= dev_cnv.min_value)) {
										dev_cnv.draw_status(dev_cnv.value + dev_cnv.handover_direction * dev_cnv.granularity, true);
									}
								}
							}
						}
						set_devices();
					}

					if (handover_refresh_time == 0) {

						handover_timer = setTimeout(handover_button_action, handover_button_delay);
						handover_refresh_time = new Date().getTime() + MOUSE_REPEAT_DELAY;
						handover_button_delay = MOUSE_REPEAT_PERIOD;

					} else {
						var t = new Date().getTime();
						if ((t - handover_refresh_time) <= MOUSE_REPEAT_PERIOD) {
							handover_timer = setTimeout(handover_button_action, handover_button_delay);
							handover_button_delay = MOUSE_REPEAT_PERIOD;
							handover_refresh_time = t + MOUSE_REPEAT_PERIOD;
						} else {
							handover_timer = setTimeout(handover_button_action, 1000);
							handover_refresh_time = t + 1000;
						}
					}
				}
			}



			function handover_compute_direction()
			{
				var i;
				var min = -1;
				var max = -1;

				for (i = 0; i < Devices_per_group; i ++) {
					var dev_cnv  = Devices_canvases[i];
					dev_cnv.handover_direction = 0;
					if (dev_cnv.device_type == DEVICE_ATTENUATOR) {
						if (dev_cnv.selected) {
							if ((min < 0) || (dev_cnv.value < min))
								min = dev_cnv.value;
							if ((max < 0) || (dev_cnv.value > max))
								max = dev_cnv.value;
						}
					}
				}
				if (min == max)
					return;
				var middle = (min + max) / 2;
				for (i = 0; i < Devices_per_group; i ++) {
					var dev_cnv  = Devices_canvases[i];
					if (dev_cnv.device_type == DEVICE_ATTENUATOR) {
						if (dev_cnv.selected) {
							if (dev_cnv.value > middle)
								dev_cnv.handover_direction = -1;
							else
								dev_cnv.handover_direction =  1;
						}
					}
				}
				handover_direction_computed = true;
			}



			// Two global variables used in a hack to avoid congestion persistence.
			var refresh_date;
			var refresh_start_time = 0;


			/// \brief Get the device values from the server and display them.
			///
			function refresh_devices()
			{
				var cnv;

				refresh_date = new Date();
				refresh_start_time = refresh_date.getTime();

				jQuery.ajax({
					type: "GET",
					url:"cgi-bin/get-shm-data",
					dataType: 'text',
					async: ! First_call,
					success: function(data, textStatus, jqXHR) {
						try {
								var response = data;
								var values = response.split("%");
								var i = 0;
								var num;

								if (Setting_devices)
									return;

								if (values[0] == 0)
									return;

								First_call = false;
								Attenuators_range = values[4];
								Throws_per_switch = values[5];
								Switch_on_remote_position = (values[24] == 0);


								for (var row = 0; row < Matrix_canvas.nb_rows; row++) {
									for (var col = 0; col < Matrix_canvas.nb_cols; col++) {
										num = Matrix_canvas.nb_cols * row + col;
										Matrix_canvas.cell_type[row][col] = parseInt(values[32 + num * 12 + 1]);
										Matrix_canvas.cell_value[row][col] = parseInt(values[32 + num * 12 + 2]);
										Matrix_canvas.cell_lock_id[row][col] = parseInt(values[32 + num * 12 + 3]);
										Matrix_canvas.cell_min_value[row][col] = parseInt(values[32 + num * 12 + 4]);
										Matrix_canvas.cell_max_value[row][col] = parseInt(values[32 + num * 12 + 5]);
										Matrix_canvas.cell_granularity[row][col] = parseInt(values[32 + num * 12 + 6]);
										Matrix_canvas.cell_factor[row][col] = parseFloat(values[32 + num * 12 + 7]);
										if (Matrix_canvas.cell_type[row][col] == DEVICE_ATTENUATOR)
											Attenuators_display_factor = Matrix_canvas.cell_factor[row][col];
									}
								}
								if (Current_display_mode == MATRIX_DISPLAY_MODE) {
									Matrix_canvas.display();
									if (Switch_on_remote_position) {
										document.getElementById("maxm-button-img").style.display = '';
										document.getElementById("plusm-button-img").style.display = '';
										document.getElementById("edit-button-img").style.display = '';
										document.getElementById("minusm-button-img").style.display = '';
										document.getElementById("minm-button-img").style.display = '';
									} else {
										document.getElementById("maxm-button-img").style.display = 'none';
										document.getElementById("plusm-button-img").style.display = 'none';
										document.getElementById("edit-button-img").style.display = 'none';
										document.getElementById("minusm-button-img").style.display = 'none';
										document.getElementById("minm-button-img").style.display = 'none';
									}
									if (Matrix_canvas.cells_selected_in_matrix == 0) {
										document.getElementById("maxm-button-img").style.display = 'none';
										document.getElementById("plusm-button-img").style.display = 'none';
										document.getElementById("edit-button-img").style.display = 'none';
										document.getElementById("minusm-button-img").style.display = 'none';
										document.getElementById("minm-button-img").style.display = 'none';
									}
									if (Matrix_canvas.continuous_cells_selected_in_matrix == 0)
										document.getElementById("edit-button-img").style.display = 'none';
								} else {
									if (Switch_on_remote_position) {
										document.getElementById("maxv-button-img").style.display = '';
										document.getElementById("plus-button-img").style.display = '';
										document.getElementById("handover-button-img").style.display = '';
										document.getElementById("minus-button-img").style.display = '';
										document.getElementById("minv-button-img").style.display = '';
										document.getElementById("all-button-img").style.display = '';
									} else {
										document.getElementById("maxv-button-img").style.display = 'none';
										document.getElementById("plus-button-img").style.display = 'none';
										document.getElementById("handover-button-img").style.display = 'none';
										document.getElementById("minus-button-img").style.display = 'none';
										document.getElementById("minv-button-img").style.display = 'none';
										document.getElementById("all-button-img").style.display = 'none';
									}
								}

								for (i = 0; i < Devices_per_group; i ++) {
									num = i + Devices_per_group * Current_group;
									var dev_cnv = Devices_canvases[i];
									dev_cnv.name_label.innerHTML = values[32 + num * 12 + 0];
									dev_cnv.device_type = parseInt(values[32 + num * 12 + 1]);
									dev_cnv.min_value = parseFloat(values[32 + num * 12 + 4]);
									dev_cnv.max_value = parseFloat(values[32 + num * 12 + 5]);
									dev_cnv.granularity = parseFloat(values[32 + num * 12 + 6]);
									dev_cnv.display_factor = parseFloat(values[32 + num * 12 + 7]);
									if (((Device_canvas_mouse_move != null) || (plus_button_action_running) || (minus_button_action_running) || (handover_button_action_running))
									 && (dev_cnv.selected))
										continue;
									dev_cnv.lock_id = parseInt(values[32 + num * 12 + 3]);
									if (dev_cnv.lock_id == 0) {
										if (dev_cnv.sid != 0) {
											if (dev_cnv.sid_error == 0) {
												// The SID may have been allocated since the status request,
												// wait for the next refresh before erasing him.
												dev_cnv.sid_error++;
											} else {
												// Automatic unlock (for instance network has been interrupted)
												dev_cnv.sid = 0;
												dev_cnv.sid_error = 0;
											}
										} else {
											dev_cnv.sid_error = 0;
										}
									}
									dev_cnv.selected = (dev_cnv.sid != 0) && (dev_cnv.lock_id == dev_cnv.sid);
									if (Current_display_mode == DEVICES_DISPLAY_MODE) {
										dev_cnv.draw_status(values[32 + num * 12 + 2], false);
									}
								}

								for (i = 0; i < Nb_groups; i ++) {
									Matrix_canvas.row_header[i] = values[32 + Devices_per_group * Nb_groups * 12 + i];
									document.getElementById("group-name-"+i).innerHTML = Matrix_canvas.row_header[i];
								}
						} catch(e) {
						}
					},
				error: function(jqXHR, textStatus, errorThrown) {
				},
				complete: function(jqXHR, textStatus)
				{
					// We re-program the execution with a normal delay of 2/10 sec.
					// In case of congestion, the delay is extended to 1 second.
					refresh_date = new Date();
					var t = refresh_date.getTime();
					if ((t - refresh_start_time) > 150)
						setTimeout(refresh_devices, 1000);
					else
						setTimeout(refresh_devices, 200);
				}
				});
			}



			function refresh_device_locks()
			{
				var dev_cnv;
				var i;
				var num;

				for (i = 0; i < Devices_per_group; i ++) {
					Devices_canvases[i].refresh_device_lock();
				}
				setTimeout(refresh_device_locks, 5000); // Every 5 sec.
			}



			function unselect_all_canvases(evt)
			{
				for (var i = 0; i < Devices_per_group; i ++) {
					Devices_canvases[i].unselect(false);
				}
			}


			/// \brief The callback to set all the selected devices to their minimal values.
			///
			function min_button_cb()
			{
				var i;

				var attenuator_selected = false;
				var switch_selected = false;
				var spst_selected = false;

				for (i = 0; i < Devices_per_group; i ++) {
					var dev_cnv = Devices_canvases[i];
					if (dev_cnv.selected) {
						if (dev_cnv.device_type == DEVICE_ATTENUATOR)
							attenuator_selected = true;
						if (dev_cnv.device_type == DEVICE_SWITCH)
							switch_selected = true;
						if (dev_cnv.device_type == DEVICE_SPST)
							spst_selected = true;
					}
				}

				if (attenuator_selected) {

					for (i = 0; i < Devices_per_group; i ++) {
						var dev_cnv = Devices_canvases[i];
						if ((dev_cnv.device_type == DEVICE_ATTENUATOR) && (dev_cnv.selected))
							dev_cnv.draw_status(0, true);
					}

				} else {
					if ((switch_selected) && (! spst_selected)) {
						for (i = 0; i < Devices_per_group; i ++) {
							var dev_cnv = Devices_canvases[i];
							if ((dev_cnv.device_type == DEVICE_SWITCH) && (dev_cnv.selected))
								dev_cnv.draw_status(0, true);
						}
					} else if ((spst_selected) && (! switch_selected)) {
						for (i = 0; i < Devices_per_group; i ++) {
							var dev_cnv = Devices_canvases[i];
							if ((dev_cnv.device_type == DEVICE_SPST) && (dev_cnv.selected))
								dev_cnv.draw_status(0, true);
						}
					}
				}

				set_devices();
			}



			/// \brief The callback to set all the selected devices to their maximal values.
			///
			function max_button_cb()
			{
				var i;

				var attenuator_selected = false;
				var switch_selected = false;
				var spst_selected = false;

				for (i = 0; i < Devices_per_group; i ++) {
					var dev_cnv = Devices_canvases[i];
					if (dev_cnv.selected) {
						if (dev_cnv.device_type == DEVICE_ATTENUATOR)
							attenuator_selected = true;
						if (dev_cnv.device_type == DEVICE_SWITCH)
							switch_selected = true;
						if (dev_cnv.device_type == DEVICE_SPST)
							spst_selected = true;
					}
				}

				if (attenuator_selected) {

					for (i = 0; i < Devices_per_group; i ++) {
						var dev_cnv = Devices_canvases[i];
						if ((dev_cnv.device_type == DEVICE_ATTENUATOR) && (dev_cnv.selected))
							dev_cnv.draw_status(Attenuators_range, true);
					}

				} else {
					if ((switch_selected) && (! spst_selected)) {
						for (i = 0; i < Devices_per_group; i ++) {
							var dev_cnv = Devices_canvases[i];
							if ((dev_cnv.device_type == DEVICE_SWITCH) && (dev_cnv.selected))
								dev_cnv.draw_status(Throws_per_switch - 1, true);
						}
					} else if ((spst_selected) && (! switch_selected)) {
						for (i = 0; i < Devices_per_group; i ++) {
							var dev_cnv = Devices_canvases[i];
							if ((dev_cnv.device_type == DEVICE_SPST) && (dev_cnv.selected))
								dev_cnv.draw_status(1, true);
						}
					}
				}

				set_devices();
			}



			function matrix_max_button_cb()
			{
				Matrix_canvas.set_all_devices_to_max();
			}



			function matrix_plus_button_cb()
			{
				Matrix_canvas.increase_all_devices();
			}



			function matrix_minus_button_cb()
			{
				Matrix_canvas.decrease_all_devices();
			}



			function matrix_min_button_cb()
			{
				Matrix_canvas.set_all_devices_to_min();
			}



			function matrix_edit_button_cb()
			{
				document.getElementById("input-value-content").max = Attenuators_range;
				$("#input-value-dialog").dialog("open");
			}



			/// \brief The callback to select or unselect all devices
			///
			function select_all_button_cb()
			{
				var i;
				var select = 0;

				var attenuator_present = false;
				var switch_present = false;
				var spst_present = false;

				for (i = 0; i < Devices_per_group; i ++) {
					var dev_cnv = Devices_canvases[i];
					if (dev_cnv.device_type == DEVICE_ATTENUATOR)
						attenuator_present = true;
					if (dev_cnv.device_type == DEVICE_SWITCH)
						switch_present = true;
					if (dev_cnv.device_type == DEVICE_SPST)
						spst_present = true;
				}

				if (attenuator_present) {

					for (i = 0; i < Devices_per_group; i ++) {
						var dev_cnv = Devices_canvases[i];
						if ((dev_cnv.device_type == DEVICE_ATTENUATOR)
						 && (User_permissions[Current_group * Devices_per_group + i] != 0)
						 && ((Matrix_canvas.cell_selected[Current_group][i])
						   || (Matrix_canvas.cells_selected_in_matrix == 0))) {
							select = ! dev_cnv.selected;
							break;
						}
					}
					if (i != Devices_per_group) {
						for (i = 0; i < Devices_per_group; i ++) {
							var dev_cnv = Devices_canvases[i];
							if ((dev_cnv.device_type == DEVICE_ATTENUATOR)
							 && (User_permissions[Current_group * Devices_per_group + i] != 0)
		 					 && ((Matrix_canvas.cell_selected[Current_group][i])
							   || (Matrix_canvas.cells_selected_in_matrix == 0))) {
								if (select) {
									if (! dev_cnv.selected)
										dev_cnv.select();
								} else {
									if (dev_cnv.selected)
										dev_cnv.unselect(true);
								}
							}
						}
					}
				} else {
					if ((switch_present) && (! spst_present)) {
						for (i = 0; i < Devices_per_group; i ++) {
							var dev_cnv = Devices_canvases[i];
							if ((dev_cnv.device_type == DEVICE_SWITCH)
							 && (User_permissions[Current_group * Devices_per_group + i] != 0)
							 && ((Matrix_canvas.cell_selected[Current_group][i])
							   || (Matrix_canvas.cells_selected_in_matrix == 0))) {
								select = ! dev_cnv.selected;
								break;
							}
						}
						if (i != Devices_per_group) {
							for (i = 0; i < Devices_per_group; i ++) {
								var dev_cnv = Devices_canvases[i];
								if ((dev_cnv.device_type == DEVICE_SWITCH)
								 && (User_permissions[Current_group * Devices_per_group + i] != 0)
			 					 && ((Matrix_canvas.cell_selected[Current_group][i])
								   || (Matrix_canvas.cells_selected_in_matrix == 0))) {
									if (select) {
										if (! dev_cnv.selected)
											dev_cnv.select();
									} else {
										if (dev_cnv.selected)
											dev_cnv.unselect(true);
									}
								}
							}
						}
					} else if ((spst_present) && (! switch_present)) {
						for (i = 0; i < Devices_per_group; i ++) {
							var dev_cnv = Devices_canvases[i];
							if ((dev_cnv.device_type == DEVICE_SPST)
							 && (User_permissions[Current_group * Devices_per_group + i] != 0)
							 && ((Matrix_canvas.cell_selected[Current_group][i])
							   || (Matrix_canvas.cells_selected_in_matrix == 0))) {
								select = ! dev_cnv.selected;
								break;
							}
						}
						if (i != Devices_per_group) {
							for (i = 0; i < Devices_per_group; i ++) {
								var dev_cnv = Devices_canvases[i];
								if ((dev_cnv.device_type == DEVICE_SPST)
								 && (User_permissions[Current_group * Devices_per_group + i] != 0)
			 					 && ((Matrix_canvas.cell_selected[Current_group][i])
								   || (Matrix_canvas.cells_selected_in_matrix == 0))) {
									if (select) {
										if (! dev_cnv.selected)
											dev_cnv.select();
									} else {
										if (dev_cnv.selected)
											dev_cnv.unselect(true);
									}
								}
							}
						}
					}

				}
			}



			/// \brief Send the values of the selected devices to the embedded server.
			///
			function set_devices()
			{
				var i;

				Setting_devices = true;

				var line = "" + Current_group + ",";

				for (i = 0; i < Devices_per_group; i ++) {

					var dev_cnv = Devices_canvases[i];
					if (dev_cnv.selected)
						line = line + dev_cnv.value + "," + dev_cnv.sid + ",";
					else
						line = line + "-1,-1,";
				}

				jQuery.ajax({
					type: "GET",
					url:"cgi-bin/set-group-values?" + line,
					dataType: 'text',
					async: true,
					complete: function(jqXHR, text) {
						Setting_devices = false;
					}
				});
			}



			/// \brief Draw the background of all devices.
			///
			function draw_backgrounds()
			{
				try {
					for (var i = 0; i < Devices_per_group; i ++) {

						Devices_canvases[i].draw_background();
						Devices_canvases[i].set_offsets();
					}

				} catch(err) {
				}
			}



			/// \brief Check if the left mouse button is pressed in the given event.
			///
			/// Comes from an answer to the question #3944122 on Stack Overflow.
			///
			function left_button_in_event(evt)
			{
				evt = evt || window.event;
				var button = evt.which || evt.button;
				return button == 1;
			}



			function init_input_value_dialog()
			{
				var form;
				var dialog;

				dialog = $("#input-value-dialog").dialog({
					autoOpen: false,
					height: 250,
					width: 400,
					modal: true,
					buttons: {
						"Ok": {
							id: 'input-value-dialog-ok',
							text: "Ok",
							click: function()
							{
								input_value_dialog_cb();
								dialog.dialog("close");
							}
						},
						"Cancel": {
							id: 'input-value-dialog-cancel',
							text: "Cancel",
							click : function()
							{
								dialog.dialog("close");
							},
						},
					},
					close: function() {
						form[0].reset();
					}
				});

				form = dialog.find("form").on("submit", function(event) {
					event.preventDefault();
					input_value_dialog_cb();
					dialog.dialog("close");
				});
			}



			function input_value_dialog_cb()
			{
				try {
					var value = parseFloat(document.getElementById("input-value-content").value);
					value = value / Attenuators_display_factor;
					Matrix_canvas.set_all_continuous_devices_to(Math.round(value));
				} catch (err) {
				}
			}

		</script>
	</body>
</html>
